/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.History;
import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.io.ImageWriter;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    private static String defaultDirectory = null;
    private ImagePlus imp;
    private FileInfo fi;
    private String name;
    private String directory;

    public FileSaver(ImagePlus imp) {
        this.imp = imp;
        this.fi = imp.getFileInfo();
    }

    public boolean save() {
        FileInfo fi_ = this.imp.getOriginalFileInfo();
        switch (fi_.fileFormat) {
            case 4: {
                return this.saveAsFITS(this.fi.directory + this.fi.fileName);
            }
            case 3: {
                if (this.fi.fileName.endsWith("gif")) {
                    return this.saveAsGif(this.fi.directory + this.fi.fileName);
                }
                return this.saveAsJpeg(this.fi.directory + this.fi.fileName);
            }
            case 1: {
                if (this.imp.getStackSize() == 1) {
                    return this.saveAsRaw(this.fi.directory + this.fi.fileName);
                }
                return this.saveAsRawStack(this.fi.directory + this.fi.fileName);
            }
            case 5: {
                return this.saveAsBmp(this.fi.directory + this.fi.fileName);
            }
            case 2: {
                if (this.imp.getStackSize() == 1) {
                    return this.saveAsTiff(this.fi.directory + this.fi.fileName);
                }
                return this.saveAsTiffStack(this.fi.directory + this.fi.fileName);
            }
        }
        return this.saveAsTiff();
    }

    String getPath(String type, String extension) {
        this.name = "fic";
        SaveDialog sd = new SaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        this.imp.startTiming();
        String path = this.directory + this.name;
        return path;
    }

    public boolean saveAsTiff() {
        String path = this.getPath("TIFF", ".tif");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsTiff(path);
        }
        return this.saveAsTiffStack(path);
    }

    public boolean saveAsTiff(String path) {
        this.fi.nImages = 1;
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsTiffStack(String path) {
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsZip() {
        String path = this.getPath("TIFF/ZIP", ".zip");
        if (path == null) {
            return false;
        }
        return this.saveAsZip(path);
    }

    public boolean saveAsZip(String path) {
        if (!path.endsWith(".zip")) {
            path = path + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        this.fi.description = this.getDescriptionString();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            zos.putNextEntry(new ZipEntry(this.name));
            TiffEncoder te = new TiffEncoder(this.fi);
            te.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4 || type == 1 || type == 2) {
            IJ.error("To save as Gif, the image must be \"8-bit\" or \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        return this.saveAsGif(path);
    }

    public boolean saveAsGif(String path) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        try {
            byte[] pixels = (byte[])this.imp.getProcessor().getPixels();
            GifEncoder encoder = new GifEncoder(this.fi.width, this.fi.height, pixels, this.fi.reds, this.fi.greens, this.fi.blues);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            encoder.write(output);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imp) {
        return true;
    }

    public boolean saveAsJpeg() {
        String path = this.getPath("JPEG", ".jpg");
        if (path == null) {
            return false;
        }
        return this.saveAsJpeg(path);
    }

    public boolean saveAsFITS() {
        String path = this.getPath("FITS", ".fit");
        if (path == null) {
            return false;
        }
        return this.saveAsFITS(path);
    }

    public boolean saveAsJpeg(String path) {
        Object jpegWriter = null;
        WindowManager.setTempCurrentImage(this.imp);
        if (IJ.isJava2()) {
            IJ.runPlugIn("ij.plugin.JpegWriter", path);
        } else {
            IJ.runPlugIn("Jpeg_Writer", path);
        }
        WindowManager.setTempCurrentImage(null);
        this.updateImp(this.fi, 3);
        return true;
    }

    public boolean saveAsFITS(String path) {
        Object fitsWriter = null;
        WindowManager.setTempCurrentImage(this.imp);
        if (IJ.isJava2()) {
            IJ.runPlugIn("ij.plugin.RB_FITS_Writer", path);
        } else {
            IJ.runPlugIn("RB_FITS_Writer", path);
        }
        WindowManager.setTempCurrentImage(null);
        this.updateImp(this.fi, 4);
        return true;
    }

    public boolean saveAsBmp() {
        String path = this.getPath("BMP", ".bmp");
        if (path == null) {
            return false;
        }
        return this.saveAsBmp(path);
    }

    public boolean saveAsBmp(String path) {
        WindowManager.setTempCurrentImage(this.imp);
        IJ.runPlugIn("ij.plugin.BMP_Writer", path);
        WindowManager.setTempCurrentImage(null);
        return true;
    }

    public boolean saveAsRaw() {
        String path = this.getPath("Raw", ".raw");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(path);
        }
        return this.saveAsRawStack(path);
    }

    public boolean saveAsRaw(String path) {
        this.fi.nImages = 1;
        try {
            ImageWriter file = new ImageWriter(this.fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsRawStack(String path) {
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            ImageWriter file = new ImageWriter(this.fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String path = this.getPath("Text", ".txt");
        if (path == null) {
            return false;
        }
        return this.saveAsText(path);
    }

    public boolean saveAsText(String path) {
        try {
            Calibration cal = this.imp.getCalibration();
            int precision = Analyzer.getPrecision();
            TextEncoder file = new TextEncoder(this.imp.getProcessor(), cal, precision);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String path = this.getPath("LUT", ".lut");
        if (path == null) {
            return false;
        }
        return this.saveAsLut(path);
    }

    public boolean saveAsLut(String path) {
        LookUpTable lut = this.imp.createLut();
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (mapSize < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        byte[] pixels = new byte[768];
        for (int i = 0; i < 256; ++i) {
            pixels[i] = reds[i];
            pixels[i + 256] = greens[i];
            pixels[i + 512] = blues[i];
        }
        FileInfo fi = new FileInfo();
        fi.width = 768;
        fi.height = 1;
        fi.pixels = pixels;
        try {
            ImageWriter file = new ImageWriter(fi);
            FileOutputStream out = new FileOutputStream(path);
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fi, int fileFormat) {
        this.imp.changes = false;
        if (this.name != null) {
            History.addFiletoHistory(this.directory + this.name);
            History.synchronizeHistory(IJ.getInstance().getMenuBar().getMenu(0), false);
            this.imp.updateAndDraw();
            Opener o = new Opener();
            o.open(this.directory + this.name);
        }
    }

    void showErrorMessage(IOException e) {
        IJ.error("An error occured writing the file.\n \n" + e);
    }

    String getDescriptionString() {
        boolean enhancedLut;
        StringBuffer sb = new StringBuffer(100);
        sb.append("ImageJ=1.1\n");
        if (this.fi.nImages > 1) {
            sb.append("images=" + this.fi.nImages + "\n");
        }
        if (this.fi.unit != null) {
            sb.append("unit=" + this.fi.unit + "\n");
        }
        if (this.fi.valueUnit != null) {
            sb.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                for (int i = 0; i < this.fi.coefficients.length; ++i) {
                    sb.append("c" + i + "=" + this.fi.coefficients[i] + "\n");
                }
            }
            sb.append("vunit=" + this.fi.valueUnit + "\n");
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 0.0 && this.fi.pixelDepth != 1.0) {
                sb.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (this.fi.frameInterval != 0.0) {
                double fps = 1.0 / this.fi.frameInterval;
                if ((double)((int)fps) == fps) {
                    sb.append("fps=" + (int)fps + "\n");
                } else {
                    sb.append("fps=" + fps + "\n");
                }
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int type = this.imp.getType();
        boolean bl = enhancedLut = !(type != 0 && type != 3 || min == 0.0 && max == 255.0);
        if (enhancedLut || type == 1 || type == 2) {
            sb.append("min=" + min + "\n");
            sb.append("max=" + max + "\n");
        }
        Calibration cal = this.imp.getCalibration();
        if (cal.xOrigin != 0.0) {
            sb.append("xorigin=" + cal.xOrigin + "\n");
        }
        if (cal.yOrigin != 0.0) {
            sb.append("yorigin=" + cal.yOrigin + "\n");
        }
        if (cal.zOrigin != 0.0) {
            sb.append("zorigin=" + cal.zOrigin + "\n");
        }
        if (cal.info != null && cal.info.length() <= 64 && cal.info.indexOf(61) == -1 && cal.info.indexOf(10) == -1) {
            sb.append("info=" + cal.info + "\n");
        }
        sb.append('\u0000');
        return new String(sb);
    }
}

