/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    private double bscale = 1.0;
    private double bzero = 0.0;
    private double restfreq = 0.0;
    private double crval1 = 0.0;
    private double crval2 = 0.0;
    private double crval3 = 0.0;
    private double cdelt1 = 0.0;
    private double crpix1 = 0.0;
    private double deltav = 0.0;
    private double velolsr = 0.0;

    public FitsDecoder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FileInfo getInfo() throws IOException {
        FileInfo fi = new FileInfo();
        fi.fileFormat = 4;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = 0;
        fi.height = 1;
        fi.offset = 0;
        this.f = new DataInputStream(new FileInputStream(this.directory + this.fileName));
        String s = this.getString(80);
        this.info.append(s + "\n");
        if (!s.startsWith("SIMPLE")) {
            this.f.close();
            return null;
        }
        int count = 1;
        do {
            block32: {
                block33: {
                    int bitsPerPixel;
                    block35: {
                        block34: {
                            ++count;
                            s = this.getString(80);
                            this.info.append(s + "\n");
                            if (!s.startsWith("BITPIX")) break block33;
                            bitsPerPixel = this.getInteger(s);
                            if (bitsPerPixel != 8) break block34;
                            fi.fileType = 0;
                            break block32;
                        }
                        if (bitsPerPixel != -16) break block35;
                        fi.fileType = 2;
                        break block32;
                    }
                    if (bitsPerPixel == 16) {
                        fi.fileType = 1;
                        break block32;
                    } else if (bitsPerPixel == 32) {
                        fi.fileType = 3;
                        break block32;
                    } else {
                        if (bitsPerPixel != -32) {
                            IJ.error("BITPIX must be 8, 16, 32 or -32 (float).");
                            this.f.close();
                            return null;
                        }
                        fi.fileType = 4;
                    }
                    break block32;
                }
                if (s.startsWith("NAXIS1")) {
                    fi.width = this.getInteger(s);
                } else if (s.startsWith("NAXIS2")) {
                    fi.height = this.getInteger(s);
                } else if (s.startsWith("NAXIS3")) {
                    fi.nImages = this.getInteger(s);
                } else if (s.startsWith("BSCALE")) {
                    this.bscale = this.getFloat(s);
                } else if (s.startsWith("BZERO")) {
                    this.bzero = this.getFloat(s);
                } else if (s.startsWith("RESTFREQ")) {
                    this.restfreq = this.getFloat(s);
                } else if (s.startsWith("CRVAL1")) {
                    this.crval1 = this.getFloat(s);
                } else if (s.startsWith("CRVAL2")) {
                    this.crval2 = this.getFloat(s);
                } else if (s.startsWith("CRVAL3")) {
                    this.crval3 = this.getFloat(s);
                } else if (s.startsWith("CDELT1")) {
                    this.cdelt1 = this.getFloat(s);
                } else if (s.startsWith("VELO-LSR") || s.startsWith("VLSR")) {
                    this.velolsr = this.getFloat(s);
                } else if (s.startsWith("DELTAV")) {
                    this.deltav = this.getFloat(s);
                } else if (s.startsWith("CRPIX1")) {
                    this.crpix1 = this.getFloat(s);
                }
            }
            if (count <= 360 || fi.width != 0) continue;
            this.f.close();
            return null;
        } while (!s.startsWith("END"));
        this.f.close();
        fi.offset = 2880 + 2880 * ((count * 80 - 1) / 2880);
        return fi;
    }

    String getString(int length) throws IOException {
        byte[] b = new byte[length];
        this.f.read(b);
        return new String(b);
    }

    int getInteger(String s) {
        s = s.substring(10, 30);
        s = s.trim();
        return Integer.parseInt(s);
    }

    double getFloat(String s) {
        Double d;
        s = s.substring(10, 30);
        s = s.trim();
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public double getBscale() {
        return this.bscale;
    }

    public double getBzero() {
        return this.bzero;
    }

    public double getRestfreq() {
        return this.restfreq;
    }

    public double getCrval1() {
        return this.crval1;
    }

    public double getCrval2() {
        return this.crval2;
    }

    public double getCrval3() {
        return this.crval3;
    }

    public double getCdelt1() {
        return this.cdelt1;
    }

    public double getCrpix1() {
        return this.crpix1;
    }

    public double getVelolsr() {
        return this.velolsr;
    }

    public double getDeltav() {
        return this.deltav;
    }

    public String getHeaderInfo() {
        return new String(this.info);
    }
}

