/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LutLoader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory = null;

    public void run(String arg) {
        FileInfo fi = new FileInfo();
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        fi.lutSize = 256;
        int nColors = 0;
        if (arg.equals("invert")) {
            this.invertLut();
            return;
        }
        if (arg.equals("fire")) {
            nColors = this.fire(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("grays")) {
            nColors = this.grays(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("igrays")) {
            nColors = this.igrays(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("ice")) {
            nColors = this.ice(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("spectrum")) {
            nColors = this.spectrum(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("3-3-2 RGB")) {
            nColors = this.rgb332(fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("red")) {
            nColors = this.primaryColor(4, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("green")) {
            nColors = this.primaryColor(2, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("blue")) {
            nColors = this.primaryColor(1, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("cyan")) {
            nColors = this.primaryColor(3, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("magenta")) {
            nColors = this.primaryColor(5, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("yellow")) {
            nColors = this.primaryColor(6, fi.reds, fi.greens, fi.blues);
        } else if (arg.equals("redgreen")) {
            nColors = this.redGreen(fi.reds, fi.greens, fi.blues);
        }
        if (nColors > 0) {
            if (nColors < 256) {
                this.interpolate(fi.reds, fi.greens, fi.blues, nColors);
            }
            fi.fileName = arg;
            this.showLut(fi, true);
            Menus.updateMenus();
            return;
        }
        OpenDialog od = new OpenDialog("Open LUT...", arg);
        fi.directory = od.getDirectory();
        fi.fileName = od.getFileName();
        if (fi.fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + fi.directory + fi.fileName);
        try {
            int size = this.readLut(fi, false);
            if (size == 0) {
                this.readLut(fi, true);
            }
        }
        catch (IOException e) {
            IJ.error(e.getMessage());
            return;
        }
        this.showLut(fi, arg.equals(""));
        IJ.showStatus("");
    }

    void showLut(FileInfo fi, boolean showImage) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (imp.getType() == 4) {
                IJ.error(IJ.getPluginBundle().getString("LutRGBErr"));
            } else {
                ImageProcessor ip = imp.getProcessor();
                IndexColorModel cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
                ip.setColorModel(cm);
                if (imp.getStackSize() > 1) {
                    imp.getStack().setColorModel(cm);
                }
                imp.updateAndDraw();
            }
        } else {
            this.createImage(fi, showImage);
        }
    }

    void invertLut() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getType() == 4) {
            IJ.error(IJ.getPluginBundle().getString("LutRGBErr"));
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        ip.invertLut();
        if (imp.getStackSize() > 1) {
            imp.getStack().setColorModel(ip.getColorModel());
        }
        imp.updateAndDraw();
        Roi r = imp.getRoi();
        if (r != null) {
            imp.killRoi();
        }
        imp.draw();
        if (r != null) {
            imp.setRoi(r);
        }
    }

    int fire(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] b = new int[]{31, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    int grays(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            reds[i] = (byte)i;
            greens[i] = (byte)i;
            blues[i] = (byte)i;
        }
        return 256;
    }

    int igrays(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            byte b;
            reds[i] = b = (byte)(255 - i);
            greens[i] = b;
            blues[i] = b;
        }
        return 256;
    }

    int primaryColor(int color, byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            if ((color & 4) != 0) {
                reds[i] = (byte)i;
            }
            if ((color & 2) != 0) {
                greens[i] = (byte)i;
            }
            if ((color & 1) == 0) continue;
            blues[i] = (byte)i;
        }
        return 256;
    }

    int ice(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229, 242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230};
        int[] g = new int[]{156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93, 81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0};
        int[] b = new int[]{140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    int spectrum(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
            reds[i] = (byte)c.getRed();
            greens[i] = (byte)c.getGreen();
            blues[i] = (byte)c.getBlue();
        }
        return 256;
    }

    int rgb332(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            reds[i] = (byte)(i & 0xE0);
            greens[i] = (byte)(i << 3 & 0xE0);
            blues[i] = (byte)(i << 6 & 0xC0);
        }
        return 256;
    }

    int redGreen(byte[] reds, byte[] greens, byte[] blues) {
        int i;
        for (i = 0; i < 128; ++i) {
            reds[i] = (byte)(i * 2);
            greens[i] = 0;
            blues[i] = 0;
        }
        for (i = 128; i < 256; ++i) {
            reds[i] = 0;
            greens[i] = (byte)(i * 2);
            blues[i] = 0;
        }
        return 256;
    }

    void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    int readLut(FileInfo fi, boolean raw) throws IOException {
        InputStream is = fi.url == null || fi.url.equals("") ? new FileInputStream(fi.directory + fi.fileName) : new URL(fi.url + fi.fileName).openStream();
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                return 0;
            }
            short version = f.readShort();
            nColors = f.readShort();
            short start = f.readShort();
            short end = f.readShort();
            long fill1 = f.readLong();
            long fill2 = f.readLong();
            int filler = f.readInt();
        }
        f.read(fi.reds, 0, nColors);
        f.read(fi.greens, 0, nColors);
        f.read(fi.blues, 0, nColors);
        if (nColors < 256) {
            this.interpolate(fi.reds, fi.greens, fi.blues, nColors);
        }
        f.close();
        return 256;
    }

    void createImage(FileInfo fi, boolean show) {
        int width = 256;
        int height = 32;
        IndexColorModel cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
        byte[] pixels = new byte[width * height];
        ByteProcessor bp = new ByteProcessor(width, height, pixels, cm);
        int[] ramp = new int[width];
        for (int i = 0; i < width; ++i) {
            ramp[i] = i;
        }
        for (int y = 0; y < height; ++y) {
            bp.putRow(0, y, ramp, width);
        }
        this.setProcessor(fi.fileName, bp);
        if (show) {
            this.show();
        }
    }
}

