/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.OpticalSpectrumProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TextReader
implements PlugIn {
    int words = 0;
    int chars = 0;
    int lines = 0;
    int width = 1;
    String directory;
    String name;
    String path;

    public void run(String arg) {
        if (this.showDialog()) {
            IJ.showStatus(IJ.getBundle().getString("Opening") + this.path);
            ImageProcessor ip = this.open(this.path);
            if (ip != null) {
                new ImagePlus(this.name, ip).show();
            }
        }
    }

    boolean showDialog() {
        OpenDialog od = new OpenDialog(IJ.getBundle().getString("OpenTextImage"), null);
        this.directory = od.getDirectory();
        this.name = od.getFileName();
        if (this.name != null) {
            this.path = this.directory + this.name;
        }
        return this.name != null;
    }

    public ImageProcessor open() {
        if (this.showDialog()) {
            return this.open(this.path);
        }
        return null;
    }

    public ImageProcessor open(String path) {
        FloatProcessor ip = null;
        try {
            this.lines = 0;
            this.chars = 0;
            this.words = 0;
            BufferedReader r = new BufferedReader(new FileReader(path));
            this.countLines(r);
            ((Reader)r).close();
            r = new BufferedReader(new FileReader(path));
            if (this.width == 2) {
                this.width = 100;
                this.lines -= 2;
                float[] pixels = new float[this.width * this.lines];
                float[] wlValues = new float[this.lines];
                ip = new OpticalSpectrumProcessor(this.lines, this.width, pixels, null, wlValues);
                this.read(r, this.lines, pixels, wlValues);
            } else {
                float[] pixels = new float[this.width * this.lines];
                ip = new FloatProcessor(this.width, this.lines, pixels, null);
                this.read(r, this.width * this.lines, pixels);
            }
            ((ImageProcessor)ip).resetMinAndMax();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("TextReader", msg);
            ip = null;
        }
        return ip;
    }

    public String getName() {
        return this.name;
    }

    void countLines(Reader r) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        int wordsPerLine = 0;
        int wordsInPreviousLine = 0;
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.eolIsSignificant(true);
        while (tok.nextToken() != -1) {
            switch (tok.ttype) {
                case 10: {
                    ++this.lines;
                    if (wordsPerLine == 0) {
                        --this.lines;
                    }
                    if (this.lines == 1) {
                        this.width = wordsPerLine;
                    } else if (wordsPerLine != 0 && wordsPerLine != wordsInPreviousLine) {
                        throw new IOException("Line " + this.lines + " is not the same length as the first line.");
                    }
                    if (wordsPerLine != 0) {
                        wordsInPreviousLine = wordsPerLine;
                    }
                    wordsPerLine = 0;
                    if (this.lines % 20 != 0 || this.width <= 1 || this.lines > this.width) break;
                    IJ.showProgress((double)this.lines / (double)this.width / 2.0);
                    break;
                }
                case -3: {
                    ++this.words;
                    ++wordsPerLine;
                }
            }
        }
    }

    void read(Reader r, int size, float[] pixels) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.parseNumbers();
        int i = 0;
        int inc = size / 20;
        if (inc < 1) {
            inc = 1;
        }
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2) continue;
            pixels[i++] = (float)tok.nval;
            if (i == size) break;
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }

    void read(Reader r, int size, float[] pixels, float[] wlValues) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.parseNumbers();
        int i = 0;
        int inc = size / 20;
        if (inc < 1) {
            inc = 1;
        }
        tok.nextToken();
        tok.nextToken();
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2) continue;
            wlValues[i] = (float)tok.nval;
            tok.nextToken();
            float tmp = (float)tok.nval;
            for (int ii = 0; ii < 100; ++ii) {
                pixels[ii * size + i] = tmp;
            }
            if (++i == size) break;
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }
}

