/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.ior.Identifiable;
import com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
import com.sun.corba.se.spi.ior.WriteContents;
import com.sun.corba.se.spi.orb.ORB;
import java.util.List;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class EncapsulationUtility {
    private EncapsulationUtility() {
    }

    public static void readIdentifiableSequence(List list, IdentifiableFactoryFinder identifiableFactoryFinder, InputStream inputStream) {
        int n2 = inputStream.read_long();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = inputStream.read_long();
            Identifiable identifiable = identifiableFactoryFinder.create(n3, inputStream);
            list.add(identifiable);
        }
    }

    public static void writeIdentifiableSequence(List list, OutputStream outputStream) {
        outputStream.write_long(list.size());
        for (Identifiable identifiable : list) {
            outputStream.write_long(identifiable.getId());
            identifiable.write(outputStream);
        }
    }

    public static void writeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        byte[] byArray = ((CDROutputStream)outputStream).toByteArray();
        outputStream2.write_long(byArray.length);
        outputStream2.write_octet_array(byArray, 0, byArray.length);
    }

    public static InputStream getEncapsulationStream(InputStream inputStream) {
        byte[] byArray = EncapsulationUtility.readOctets(inputStream);
        EncapsInputStream encapsInputStream = new EncapsInputStream(inputStream.orb(), byArray, byArray.length);
        encapsInputStream.consumeEndian();
        return encapsInputStream;
    }

    public static byte[] readOctets(InputStream inputStream) {
        int n2 = inputStream.read_ulong();
        byte[] byArray = new byte[n2];
        inputStream.read_octet_array(byArray, 0, n2);
        return byArray;
    }

    public static void writeEncapsulation(WriteContents writeContents, OutputStream outputStream) {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream((ORB)outputStream.orb());
        encapsOutputStream.putEndian();
        writeContents.writeContents(encapsOutputStream);
        EncapsulationUtility.writeOutputStream(encapsOutputStream, outputStream);
    }
}

