/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class PropMap
extends TreeMap {
    ArrayList _listeners = new ArrayList(1);
    private static Map defaultProps;

    void addListener(PropertyChangeListener propertyChangeListener) {
        this._listeners.add(propertyChangeListener);
    }

    void removeListener(PropertyChangeListener propertyChangeListener) {
        this._listeners.remove(propertyChangeListener);
    }

    void addListeners(ArrayList arrayList) {
        this._listeners.addAll(arrayList);
    }

    void removeListeners(ArrayList arrayList) {
        this._listeners.removeAll(arrayList);
    }

    public Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        if (object2 != object3 && this._listeners.size() > 0) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, (String)object, object3, object2);
            for (PropertyChangeListener propertyChangeListener : this._listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        return object3;
    }

    PropMap() {
        this.putAll(defaultProps);
    }

    SortedMap prefixMap(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return this;
        }
        char c2 = (char)(string.charAt(n2 - 1) + '\u0001');
        String string2 = string.substring(0, n2 - 1) + c2;
        return this.subMap(string, string2);
    }

    String getProperty(String string) {
        return (String)this.get(string);
    }

    String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    String setProperty(String string, String string2) {
        return (String)this.put(string, string2);
    }

    List getProperties(String string) {
        Collection collection = this.prefixMap(string).values();
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        while (arrayList.remove(null)) {
        }
        return arrayList;
    }

    private boolean toBoolean(String string) {
        return Boolean.valueOf(string);
    }

    boolean getBoolean(String string) {
        return this.toBoolean(this.getProperty(string));
    }

    boolean setBoolean(String string, boolean bl2) {
        return this.toBoolean(this.setProperty(string, String.valueOf(bl2)));
    }

    int toInteger(String string) {
        if (string == null) {
            return 0;
        }
        if ("true".equals(string)) {
            return 1;
        }
        if ("false".equals(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    int getInteger(String string) {
        return this.toInteger(this.getProperty(string));
    }

    int setInteger(String string, int n2) {
        return this.toInteger(this.setProperty(string, String.valueOf(n2)));
    }

    long toLong(String string) {
        try {
            return string == null ? 0L : Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String string) {
        return this.toLong(this.getProperty(string));
    }

    long setLong(String string, long l2) {
        return this.toLong(this.setProperty(string, String.valueOf(l2)));
    }

    int getTime(String string) {
        String string2 = this.getProperty(string, "0");
        if ("now".equals(string2)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long l2 = this.toLong(string2);
        if (l2 < 10000000000L && !"0".equals(string2)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + string2);
        }
        return (int)((l2 + 500L) / 1000L);
    }

    void list(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.list(printWriter);
        printWriter.flush();
    }

    void list(PrintWriter printWriter) {
        printWriter.println("#PACK200[");
        Set set = defaultProps.entrySet();
        for (Map.Entry entry : this.entrySet()) {
            if (set.contains(entry)) continue;
            printWriter.println("  " + entry.getKey() + " = " + entry.getValue());
        }
        printWriter.println("#]");
    }

    static {
        Properties properties = new Properties();
        properties.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        properties.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        properties.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        properties.put("pack.segment.limit", "1000000");
        properties.put("pack.keep.file.order", "true");
        properties.put("pack.modification.time", "keep");
        properties.put("pack.deflate.hint", "keep");
        properties.put("pack.unknown.attribute", "pass");
        properties.put("pack.effort", "5");
        try {
            String string = "intrinsic.properties";
            InputStream inputStream = PackerImpl.class.getResourceAsStream(string);
            properties.load(new BufferedInputStream(inputStream));
            inputStream.close();
            for (Map.Entry entry : properties.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                if (!string2.startsWith("attribute.")) continue;
                entry.setValue(Attribute.normalizeLayoutString(string3));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        defaultProps = new HashMap<Object, Object>(properties);
    }
}

