/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public class ProtectionDomain {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean staticPermissions;
    private static final Debug debug = Debug.getInstance("domain");

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticPermissions = false;
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    public String toString() {
        Serializable serializable;
        String string = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            serializable = new StringBuilder("(principals ");
            for (int i2 = 0; i2 < this.principals.length; ++i2) {
                ((StringBuilder)serializable).append(this.principals[i2].getClass().getName() + " \"" + this.principals[i2].getName() + "\"");
                if (i2 < this.principals.length - 1) {
                    ((StringBuilder)serializable).append(",\n");
                    continue;
                }
                ((StringBuilder)serializable).append(")\n");
            }
            string = ((StringBuilder)serializable).toString();
        }
        serializable = Policy.isSet() && ProtectionDomain.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n" + " " + this.classloader + "\n" + " " + string + "\n" + " " + serializable + "\n";
    }

    private static boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        if (debug != null) {
            if (securityManager.getClass().getClassLoader() == null && Policy.getPolicyNoCheck().getClass().getClassLoader() == null) {
                return true;
            }
        } else {
            try {
                securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
                return true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection mergePermissions() {
        Permission permission;
        Enumeration<Permission> enumeration;
        PermissionCollection permissionCollection;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection2 = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy policy = Policy.getPolicyNoCheck();
                return policy.getPermissions(ProtectionDomain.this);
            }
        });
        Permissions permissions = new Permissions();
        int n2 = 32;
        int n3 = 8;
        ArrayList<Permission> arrayList = new ArrayList<Permission>(n3);
        ArrayList<Permission> arrayList2 = new ArrayList<Permission>(n2);
        if (this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                enumeration = this.permissions.elements();
                while (enumeration.hasMoreElements()) {
                    permission = enumeration.nextElement();
                    arrayList.add(permission);
                }
            }
        }
        if (permissionCollection2 != null) {
            permissionCollection = permissionCollection2;
            synchronized (permissionCollection) {
                enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    arrayList2.add(enumeration.nextElement());
                    ++n3;
                }
            }
        }
        if (permissionCollection2 != null && this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                enumeration = this.permissions.elements();
                block11: while (enumeration.hasMoreElements()) {
                    permission = enumeration.nextElement();
                    Class<? extends Object> clazz = permission.getClass();
                    String string = permission.getActions();
                    String string2 = permission.getName();
                    for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                        Permission permission2 = (Permission)arrayList2.get(i2);
                        if (!clazz.isInstance(permission2) || !string2.equals(permission2.getName()) || !string.equals(permission2.getActions())) continue;
                        arrayList2.remove(i2);
                        continue block11;
                    }
                }
            }
        }
        if (permissionCollection2 != null) {
            for (int i3 = arrayList2.size() - 1; i3 >= 0; --i3) {
                permissions.add((Permission)arrayList2.get(i3));
            }
        }
        if (this.permissions != null) {
            for (int i4 = arrayList.size() - 1; i4 >= 0; --i4) {
                permissions.add((Permission)arrayList.get(i4));
            }
        }
        return permissions;
    }
}

