/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.UIAction;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    private transient PopupMenuListener popupMenuListener = null;
    private MenuKeyListener menuKeyListener = null;
    static boolean menuKeyboardHelperInstalled = false;
    static MenuKeyboardHelper menuKeyboardHelper = null;
    private static transient MouseGrabber mouseGrabber = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public BasicPopupMenuUI() {
        BasicLookAndFeel.hasPopups = true;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof BasicLookAndFeel) {
            ((BasicLookAndFeel)lookAndFeel).createdPopup();
        }
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.TRUE);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installListeners() {
        if (this.popupMenuListener == null) {
            this.popupMenuListener = new BasicPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
        if (this.menuKeyListener == null) {
            this.menuKeyListener = new BasicMenuKeyListener();
        }
        this.popupMenu.addMenuKeyListener(this.menuKeyListener);
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (!menuKeyboardHelperInstalled) {
            if (menuKeyboardHelper == null) {
                menuKeyboardHelper = new MenuKeyboardHelper();
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(menuKeyboardHelper);
            menuKeyboardHelperInstalled = true;
        }
    }

    protected void installKeyboardActions() {
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            Object[] objectArray2;
            componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
            if (!jPopupMenu.getComponentOrientation().isLeftToRight() && (objectArray2 = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
                ((InputMap)componentInputMap2).setParent(componentInputMap);
                componentInputMap = componentInputMap2;
            }
        }
        return componentInputMap;
    }

    static ActionMap getActionMap() {
        return LazyActionMap.getActionMap(BasicPopupMenuUI.class, "PopupMenu.actionMap");
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("selectNext"));
        lazyActionMap.put(new Actions("selectPrevious"));
        lazyActionMap.put(new Actions("selectParent"));
        lazyActionMap.put(new Actions("selectChild"));
        lazyActionMap.put(new Actions("return"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
        if (this.popupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.popupMenuListener);
        }
        if (this.menuKeyListener != null) {
            this.popupMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        if (mouseGrabber != null) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.removeChangeListener(mouseGrabber);
            mouseGrabber.ungrabWindow();
            mouseGrabber = null;
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    static MenuElement getFirstPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        MenuElement menuElement = null;
        for (int i2 = 0; menuElement == null && i2 < menuElementArray.length; ++i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            menuElement = menuElementArray[i2];
        }
        return menuElement;
    }

    static JPopupMenu getLastPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        JPopupMenu jPopupMenu = null;
        for (int i2 = menuElementArray.length - 1; jPopupMenu == null && i2 >= 0; --i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            jPopupMenu = (JPopupMenu)menuElementArray[i2];
        }
        return jPopupMenu;
    }

    static List getPopups() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        ArrayList<JPopupMenu> arrayList = new ArrayList<JPopupMenu>(menuElementArray.length);
        for (int i2 = 0; i2 < menuElementArray.length; ++i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu)) continue;
            arrayList.add((JPopupMenu)menuElementArray[i2]);
        }
        return arrayList;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private static boolean checkInvokerEqual(MenuElement menuElement, MenuElement menuElement2) {
        Component component = menuElement.getComponent();
        Component component2 = menuElement2.getComponent();
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
        }
        if (component2 instanceof JPopupMenu) {
            component2 = ((JPopupMenu)component2).getInvoker();
        }
        return component == component2;
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            Component component;
            if (menuElementArray[i2] == null || (component = menuElementArray[i2].getComponent()) == null || !component.isEnabled() || !component.isVisible()) continue;
            return menuElementArray[i2];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n2, int n3) {
        for (int i2 = n2; i2 >= n3; --i2) {
            Component component;
            if (menuElementArray[i2] == null || (component = menuElementArray[i2].getComponent()) == null || !component.isEnabled() || !component.isVisible()) continue;
            return menuElementArray[i2];
        }
        return null;
    }

    static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n2, boolean bl2) {
        MenuElement menuElement = null;
        if (bl2) {
            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, n2 + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, 0, n2 - 1);
            }
        } else {
            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, n2 - 1, 0);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n2 + 1);
            }
        }
        return menuElement;
    }

    static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl2) {
        for (int i2 = 0; i2 < menuElementArray.length; ++i2) {
            if (menuElementArray[i2] != menuElement) continue;
            return BasicPopupMenuUI.findEnabledChild(menuElementArray, i2, bl2);
        }
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String CANCEL = "cancel";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_CHILD = "selectChild";
        private static final String RETURN = "return";
        private static final boolean FORWARD = true;
        private static final boolean BACKWARD = false;
        private static final boolean PARENT = false;
        private static final boolean CHILD = true;

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            if (string == CANCEL) {
                this.cancel();
            } else if (string == SELECT_NEXT) {
                this.selectItem(true);
            } else if (string == SELECT_PREVIOUS) {
                this.selectItem(false);
            } else if (string == SELECT_PARENT) {
                this.selectParentChild(false);
            } else if (string == SELECT_CHILD) {
                this.selectParentChild(true);
            } else if (string == RETURN) {
                this.doReturn();
            }
        }

        private void doReturn() {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }

        private void selectParentChild(boolean bl2) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n2 = menuElementArray.length;
            if (!bl2) {
                int n3 = n2 - 1;
                if (n2 > 2 && (menuElementArray[n3] instanceof JPopupMenu || menuElementArray[--n3] instanceof JPopupMenu) && !((JMenu)menuElementArray[n3 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n3];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n3);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n2 > 0 && menuElementArray[n2 - 1] instanceof JMenu && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n2 - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n2 + 1];
                } else {
                    menuElementArray3 = new MenuElement[n2 + 2];
                    menuElementArray3[n2 + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                menuElementArray3[n2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n2 > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = BasicPopupMenuUI.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, bl2);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n2 == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }

        private void selectItem(boolean bl2) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length < 2) {
                return;
            }
            int n2 = menuElementArray.length;
            if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n2 == 2) {
                MenuElement[] menuElementArray2;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                if (menuElement != null) {
                    menuElementArray2 = new MenuElement[4];
                    menuElementArray2[3] = menuElement;
                } else {
                    menuElementArray2 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, 2);
                menuElementArray2[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray2);
            } else if (menuElementArray[n2 - 1] instanceof JPopupMenu && menuElementArray[n2 - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n2 - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, bl2);
                if (menuElement != null) {
                    MenuElement[] menuElementArray3 = new MenuElement[n2 + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n2);
                    menuElementArray3[n2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else if (n2 > 2 && menuElementArray[n2 - 3] instanceof JPopupMenu && (menuElement = BasicPopupMenuUI.findEnabledChild((jPopupMenu = (JPopupMenu)menuElementArray[n2 - 3]).getSubElements(), jMenu, bl2)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray4 = new MenuElement[n2 - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n2 - 2);
                    menuElementArray4[n2 - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
            } else {
                MenuElement[] menuElementArray5 = menuElementArray[n2 - 2].getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray5, menuElementArray[n2 - 1], bl2);
                if (menuElement == null) {
                    menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray5, -1, bl2);
                }
                if (menuElement != null) {
                    menuElementArray[n2 - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        private void cancel() {
            MenuElement[] menuElementArray;
            JPopupMenu jPopupMenu = BasicPopupMenuUI.getLastPopup();
            if (jPopupMenu != null) {
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()).length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class BasicMenuKeyListener
    implements MenuKeyListener {
        MenuElement menuToOpen = null;

        private BasicMenuKeyListener() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (this.menuToOpen != null) {
                JPopupMenu jPopupMenu = ((JMenu)this.menuToOpen).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuKeyEvent.getPath()));
                arrayList.add(this.menuToOpen);
                arrayList.add(jPopupMenu);
                if (menuElement != null) {
                    arrayList.add(menuElement);
                }
                MenuElement[] menuElementArray = new MenuElement[]{};
                menuElementArray = arrayList.toArray(menuElementArray);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                menuKeyEvent.consume();
            }
            this.menuToOpen = null;
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            MenuElement[] menuElementArray;
            if (!Character.isLetterOrDigit(menuKeyEvent.getKeyChar())) {
                return;
            }
            int n2 = menuKeyEvent.getKeyCode();
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray2 = menuKeyEvent.getPath();
            MenuElement[] menuElementArray3 = BasicPopupMenuUI.this.popupMenu.getSubElements();
            int n3 = -1;
            int n4 = 0;
            int n5 = -1;
            int[] nArray = null;
            for (int i2 = 0; i2 < menuElementArray3.length; ++i2) {
                if (!(menuElementArray3[i2] instanceof JMenuItem)) continue;
                menuElementArray = (MenuElement[])menuElementArray3[i2];
                if (menuElementArray.isEnabled() && menuElementArray.isVisible() && n2 == menuElementArray.getMnemonic()) {
                    if (n4 == 0) {
                        n5 = i2;
                        ++n4;
                    } else {
                        if (nArray == null) {
                            nArray = new int[menuElementArray3.length];
                            nArray[0] = n5;
                        }
                        nArray[n4++] = i2;
                    }
                }
                if (!menuElementArray.isArmed()) continue;
                n3 = n4 - 1;
            }
            if (n4 != 0) {
                if (n4 == 1) {
                    JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n5];
                    if (jMenuItem instanceof JMenu) {
                        this.menuToOpen = jMenuItem;
                    } else if (jMenuItem.isEnabled()) {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick();
                    }
                    menuKeyEvent.consume();
                } else {
                    MenuElement menuElement = null;
                    menuElement = menuElementArray3[nArray[(n3 + 1) % n4]];
                    menuElementArray = new MenuElement[menuElementArray2.length + 1];
                    System.arraycopy(menuElementArray2, 0, menuElementArray, 0, menuElementArray2.length);
                    menuElementArray[menuElementArray2.length] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                    menuKeyEvent.consume();
                }
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private BasicPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            BasicLookAndFeel.playSound((JPopupMenu)popupMenuEvent.getSource(), "PopupMenu.popupSound");
        }
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = BasicPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    MenuKeyboardHelper.this.lastFocused = component;
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
        };

        private MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                Window window;
                if (!this.lastFocused.requestFocusInWindow() && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(window.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                this.invokerRootPane = null;
            }
            this.receivedKeyPressed = false;
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
                MenuElement menuElement = menuElementArray[i2];
                if (!(menuElement instanceof JPopupMenu)) continue;
                return (JPopupMenu)menuElement;
            }
            return null;
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2;
            InputMap inputMap3 = null;
            for (inputMap2 = jComponent.getInputMap(2); inputMap2 != null && !(inputMap2 instanceof UIResource); inputMap2 = inputMap2.getParent()) {
                inputMap3 = inputMap2;
            }
            if (inputMap3 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap3.setParent(inputMap);
            }
            inputMap.setParent(inputMap2);
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2;
            ActionMap actionMap3 = null;
            for (actionMap2 = jComponent.getActionMap(); actionMap2 != null && !(actionMap2 instanceof UIResource); actionMap2 = actionMap2.getParent()) {
                actionMap3 = actionMap2;
            }
            if (actionMap3 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap3.setParent(actionMap);
            }
            actionMap.setParent(actionMap2);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            for (InputMap inputMap3 = jComponent.getInputMap(2); inputMap3 != null; inputMap3 = inputMap3.getParent()) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
            }
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            for (ActionMap actionMap3 = jComponent.getActionMap(); actionMap3 != null; actionMap3 = actionMap3.getParent()) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof BasicLookAndFeel)) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.removeChangeListener(this);
                menuKeyboardHelperInstalled = false;
                return;
            }
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.checkInvokerEqual(menuElementArray[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length > 0) {
                void var5_10;
                if (jPopupMenu == null) {
                    if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                    JComponent jComponent = (JComponent)((Object)menuElementArray[1]);
                    jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component component = jPopupMenu.getInvoker();
                    if (component instanceof JFrame) {
                        JRootPane jRootPane = ((JFrame)component).getRootPane();
                    } else if (component instanceof JApplet) {
                        JRootPane jRootPane = ((JApplet)component).getRootPane();
                    } else {
                        while (!(component instanceof JComponent)) {
                            if (component == null) {
                                return;
                            }
                            component = component.getParent();
                        }
                        JComponent jComponent = (JComponent)component;
                    }
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_10);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = BasicPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.removeItems();
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }
    }

    private static class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        Window grabbedWindow;
        MenuElement[] lastPathSelected;

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
            this.lastPathSelected = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length != 0) {
                this.grabWindow(this.lastPathSelected);
            }
        }

        void grabWindow(MenuElement[] menuElementArray) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(MouseGrabber.this, 131120L);
                    return null;
                }
            });
            Component component = menuElementArray[0].getComponent();
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
            }
            Window window = this.grabbedWindow = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (this.grabbedWindow != null) {
                this.grabbedWindow.addComponentListener(this);
                this.grabbedWindow.addWindowListener(this);
            }
        }

        void ungrabWindow() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(MouseGrabber.this);
                    return null;
                }
            });
            if (this.grabbedWindow != null) {
                this.grabbedWindow.removeComponentListener(this);
                this.grabbedWindow.removeWindowListener(this);
                this.grabbedWindow = null;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                this.grabWindow(menuElementArray);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.ungrabWindow();
            }
            this.lastPathSelected = menuElementArray;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            switch (aWTEvent.getID()) {
                case 501: {
                    Component component = (Component)aWTEvent.getSource();
                    if (this.isInPopup(component) || component instanceof JMenu && ((JMenu)component).isSelected()) {
                        return;
                    }
                    if (component instanceof JComponent && ((JComponent)component).getClientProperty("doNotCancelPopup") == BasicComboBoxUI.HIDE_POPUP_KEY) break;
                    this.cancelPopupMenu();
                    boolean bl2 = UIManager.getBoolean("PopupMenu.consumeEventOnClose");
                    if (!bl2 || component instanceof MenuElement) break;
                    ((MouseEvent)aWTEvent).consume();
                    break;
                }
                case 502: {
                    Component component = (Component)aWTEvent.getSource();
                    if (!(component instanceof JMenu) && component instanceof JMenuItem) break;
                    MenuSelectionManager.defaultManager().processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 506: {
                    MenuSelectionManager.defaultManager().processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 507: {
                    if (this.isInPopup((Component)aWTEvent.getSource())) {
                        return;
                    }
                    this.cancelPopupMenu();
                }
            }
        }

        boolean isInPopup(Component component) {
            for (Component component2 = component; component2 != null && !(component2 instanceof Applet) && !(component2 instanceof Window); component2 = component2.getParent()) {
                if (!(component2 instanceof JPopupMenu)) continue;
                return true;
            }
            return false;
        }

        void cancelPopupMenu() {
            JPopupMenu jPopupMenu = (JPopupMenu)BasicPopupMenuUI.getFirstPopup();
            List list = BasicPopupMenuUI.getPopups();
            for (JPopupMenu jPopupMenu2 : list) {
                jPopupMenu2.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }
    }
}

