/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

class ComponentAccessor {
    private static Class componentClass;
    private static Field fieldX;
    private static Field fieldY;
    private static Field fieldWidth;
    private static Field fieldHeight;
    private static Method methodGetParentNoClientCode;
    private static Method methodGetFontNoClientCode;
    private static Method methodProcessEvent;
    private static Method methodEnableEvents;
    private static Field fieldParent;
    private static Field fieldBackground;
    private static Field fieldForeground;
    private static Field fieldFont;
    private static Field fieldPacked;
    private static Field fieldIgnoreRepaint;
    private static Field fieldPeer;
    private static Field fieldMetrics;
    private static Method methodResetGC;

    ComponentAccessor() {
    }

    static void setX(Component component, int n2) {
        try {
            fieldX.setInt(component, n2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static void setY(Component component, int n2) {
        try {
            fieldY.setInt(component, n2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static void setWidth(Component component, int n2) {
        try {
            fieldWidth.setInt(component, n2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static void setHeight(Component component, int n2) {
        try {
            fieldHeight.setInt(component, n2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static void setBounds(Component component, int n2, int n3, int n4, int n5) {
        try {
            fieldX.setInt(component, n2);
            fieldY.setInt(component, n3);
            fieldWidth.setInt(component, n4);
            fieldHeight.setInt(component, n5);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static int getX(Component component) {
        try {
            return fieldX.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
    }

    static int getY(Component component) {
        try {
            return fieldY.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
    }

    static int getWidth(Component component) {
        try {
            return fieldWidth.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
    }

    static int getHeight(Component component) {
        try {
            return fieldHeight.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
    }

    static boolean getIsPacked(Component component) {
        try {
            return fieldPacked.getBoolean(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
    }

    static Container getParent_NoClientCode(Component component) {
        Container container = null;
        try {
            container = (Container)methodGetParentNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return container;
    }

    static Font getFont_NoClientCode(Component component) {
        Font font = null;
        try {
            font = (Font)methodGetFontNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return font;
    }

    static void processEvent(Component component, AWTEvent aWTEvent) {
        Object var2_2 = null;
        try {
            Object[] objectArray = new Object[]{aWTEvent};
            methodProcessEvent.invoke(component, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    static void enableEvents(Component component, long l2) {
        try {
            Object[] objectArray = new Object[]{new Long(l2)};
            methodEnableEvents.invoke(component, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    static void setParent(Component component, Container container) {
        try {
            fieldParent.set(component, container);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static Color getForeground(Component component) {
        Color color = null;
        try {
            color = (Color)fieldForeground.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return color;
    }

    static Color getBackground(Component component) {
        Color color = null;
        try {
            color = (Color)fieldBackground.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return color;
    }

    static void setBackground(Component component, Color color) {
        try {
            fieldBackground.set(component, color);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static Font getFont(Component component) {
        Font font = null;
        try {
            font = (Font)fieldFont.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return font;
    }

    static ComponentPeer getPeer(Component component) {
        ComponentPeer componentPeer = null;
        try {
            componentPeer = (ComponentPeer)fieldPeer.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return componentPeer;
    }

    static void setPeer(Component component, ComponentPeer componentPeer) {
        try {
            fieldPeer.set(component, componentPeer);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static Hashtable getMetrics() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)fieldMetrics.get(Component.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return hashtable;
    }

    static boolean getIgnoreRepaint(Component component) {
        try {
            return fieldIgnoreRepaint.getBoolean(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
    }

    static void resetGC(Component component) {
        try {
            methodResetGC.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    componentClass = Class.forName("java.awt.Component");
                    fieldX = componentClass.getDeclaredField("x");
                    fieldX.setAccessible(true);
                    fieldY = componentClass.getDeclaredField("y");
                    fieldY.setAccessible(true);
                    fieldWidth = componentClass.getDeclaredField("width");
                    fieldWidth.setAccessible(true);
                    fieldHeight = componentClass.getDeclaredField("height");
                    fieldHeight.setAccessible(true);
                    fieldForeground = componentClass.getDeclaredField("foreground");
                    fieldForeground.setAccessible(true);
                    fieldBackground = componentClass.getDeclaredField("background");
                    fieldBackground.setAccessible(true);
                    fieldFont = componentClass.getDeclaredField("font");
                    fieldFont.setAccessible(true);
                    methodGetParentNoClientCode = componentClass.getDeclaredMethod("getParent_NoClientCode", null);
                    methodGetParentNoClientCode.setAccessible(true);
                    methodGetFontNoClientCode = componentClass.getDeclaredMethod("getFont_NoClientCode", null);
                    methodGetFontNoClientCode.setAccessible(true);
                    Class[] classArray = new Class[]{AWTEvent.class};
                    methodProcessEvent = componentClass.getDeclaredMethod("processEvent", classArray);
                    methodProcessEvent.setAccessible(true);
                    Class[] classArray2 = new Class[]{Long.TYPE};
                    methodEnableEvents = componentClass.getDeclaredMethod("enableEvents", classArray2);
                    methodEnableEvents.setAccessible(true);
                    fieldParent = componentClass.getDeclaredField("parent");
                    fieldParent.setAccessible(true);
                    fieldPacked = componentClass.getDeclaredField("isPacked");
                    fieldPacked.setAccessible(true);
                    fieldIgnoreRepaint = componentClass.getDeclaredField("ignoreRepaint");
                    fieldIgnoreRepaint.setAccessible(true);
                    fieldPeer = componentClass.getDeclaredField("peer");
                    fieldPeer.setAccessible(true);
                    fieldMetrics = componentClass.getDeclaredField("metrics");
                    fieldMetrics.setAccessible(true);
                    methodResetGC = componentClass.getDeclaredMethod("resetGC", null);
                    methodResetGC.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    System.out.println("Unable to create ComponentAccessor : ");
                    noSuchFieldException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Unable to create ComponentAccessor : ");
                    classNotFoundException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("Unable to create ComponentAccessor : ");
                    noSuchMethodException.printStackTrace();
                }
                return null;
            }
        });
    }
}

