/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbedder;
import sun.awt.X11.XFramePeer;

public class XEmbeddedFramePeer
extends XFramePeer {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed");
    XEmbedder embedder;

    public XEmbeddedFramePeer(EmbeddedFrame embeddedFrame) {
        super(new XCreateWindowParams(new Object[]{"target", embeddedFrame, "parent window", new Long(((XEmbeddedFrame)embeddedFrame).handle), "reparented", Boolean.TRUE, "visible", Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.embedder = new XEmbedder();
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        if (this.embedder != null) {
            this.embedder.install(this);
        }
    }

    protected String getWMName() {
        return "JavaEmbeddedFrame";
    }

    public boolean requestWindowFocus() {
        if (this.embedder != null && this.embedder.isActive()) {
            if (this.embedder.isApplicationActive()) {
                xembedLog.fine("Requesting focus from embedding host");
                this.embedder.requestFocus();
                return true;
            }
            xembedLog.fine("Host application is not active");
            return false;
        }
        xembedLog.fine("Requesting focus from X");
        return super.requestWindowFocus();
    }

    protected void requestInitialFocus() {
        if (this.embedder != null && ((EmbeddedFrame)this.target).supportsXEmbed()) {
            this.embedder.requestFocus();
        } else {
            super.requestInitialFocus();
        }
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        if (this.embedder != null && this.embedder.isActive()) {
            switch (iXAnyEvent.get_type()) {
                case 9: 
                case 10: {
                    return true;
                }
            }
        }
        return super.isEventDisabled(iXAnyEvent);
    }

    protected void traverseOutForward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Forward");
            this.embedder.traverseOutForward();
        }
    }

    protected void traverseOutBackward() {
        if (this.embedder != null && this.embedder.isActive() && this.embedder.isApplicationActive()) {
            xembedLog.fine("Traversing out Backward");
            this.embedder.traverseOutBackward();
        }
    }

    public void setBoundsPrivate(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5, 16387);
    }
}

