/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11InputMethodDescriptor;
import sun.awt.im.InputMethodAdapter;

public abstract class X11InputMethod
extends InputMethodAdapter {
    private static final Logger log = Logger.getLogger("sun.awt.X11InputMethod");
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale = X11InputMethodDescriptor.getSupportedLocale();
    private static boolean isXIMOpened = false;
    protected Container clientComponentWindow = null;
    private Component awtFocussedComponent = null;
    private Component xicFocussedComponent = null;
    private boolean isActive = false;
    private boolean isActiveClient = false;
    private static Map[] highlightStyles;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private boolean compositionEnableSupported = true;
    private boolean needCompositionEnable = false;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    private static final int INITIAL_SIZE = 64;

    private static native void initIDs();

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("Cannot open X Input Method");
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    protected abstract boolean openXIM();

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected abstract void setXICFocus(ComponentPeer var1, boolean var2, boolean var3);

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
    }

    public boolean setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return true;
        }
        return this.locale.equals(Locale.JAPAN) && locale.equals(Locale.JAPANESE) || this.locale.equals(Locale.KOREA) && locale.equals(Locale.KOREAN);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    protected final void resetXICifneeded() {
        if (this.needResetXIC) {
            if (this.getClientComponent() != this.needResetXICClient) {
                this.resetXIC();
                if (this.compositionEnableSupported && this.needCompositionEnable) {
                    try {
                        this.setCompositionEnabled(true);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        this.compositionEnableSupported = false;
                    }
                }
            }
            this.needResetXICClient = null;
            this.needResetXIC = false;
            this.needCompositionEnable = false;
        }
    }

    public synchronized void activate() {
        this.resetXICifneeded();
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.xicFocussedComponent != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XICFocused {0}, AWTFocused {1}", new Object[]{this.xicFocussedComponent, this.awtFocussedComponent});
            }
            if (this.xicFocussedComponent != this.awtFocussedComponent) {
                this.setXICFocus(this.getPeer(this.xicFocussedComponent), false, this.isActiveClient);
            }
            this.xicFocussedComponent = null;
        }
        if (this.pData == 0L) {
            if (!this.createXIC()) {
                return;
            }
            this.disposed = false;
        }
        this.setXICFocus(this.getPeer(this.awtFocussedComponent), true, this.haveActiveClient());
        this.isActive = true;
    }

    protected abstract boolean createXIC();

    public synchronized void deactivate(boolean bl2) {
        boolean bl3 = this.haveActiveClient();
        if (bl2) {
            this.xicFocussedComponent = this.awtFocussedComponent;
            this.isActiveClient = bl3;
            this.turnoffStatusWindow();
        } else {
            this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl3);
            this.xicFocussedComponent = null;
        }
        this.isActive = false;
    }

    public void hideWindows() {
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n2;
        int n3 = inputMethodHighlight.getState();
        if (n3 == 0) {
            n2 = 0;
        } else if (n3 == 1) {
            n2 = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n2;
        }
        return highlightStyles[n2];
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        if (this.isActive) {
            boolean bl2 = this.haveActiveClient();
            this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl2);
            this.setXICFocus(this.getPeer(component), true, bl2);
        }
        this.awtFocussedComponent = component;
    }

    protected void stopListening() {
        this.endComposition();
        if (this.needResetXIC) {
            this.resetXIC();
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : this.getParent(component);
        while (container != null && !(container instanceof Window)) {
            container = this.getParent(container);
        }
        return (Window)container;
    }

    protected abstract Container getParent(Component var1);

    protected abstract ComponentPeer getPeer(Component var1);

    protected abstract void awtLock();

    protected abstract void awtUnlock();

    private void postInputMethodEvent(int n2, AttributedCharacterIterator attributedCharacterIterator, int n3, TextHitInfo textHitInfo, TextHitInfo textHitInfo2, long l2) {
        Component component = this.getClientComponent();
        if (component != null) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n2, l2, attributedCharacterIterator, n3, textHitInfo, textHitInfo2);
            SunToolkit.postEvent(SunToolkit.targetToAppContext(component), inputMethodEvent);
        }
    }

    private void postInputMethodEvent(int n2, AttributedCharacterIterator attributedCharacterIterator, int n3, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this.postInputMethodEvent(n2, attributedCharacterIterator, n3, textHitInfo, textHitInfo2, EventQueue.getMostRecentEventTime());
    }

    void dispatchCommittedText(String string, long l2) {
        if (string == null) {
            return;
        }
        if (this.composedText == null) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null, l2);
        } else {
            this.committedText = string;
        }
    }

    private void dispatchCommittedText(String string) {
        this.dispatchCommittedText(string, EventQueue.getMostRecentEventTime());
    }

    void dispatchComposedText(String string, int[] nArray, int n2, int n3, int n4, long l2) {
        int n5;
        int n6;
        AttributedString attributedString;
        int n7;
        if (this.disposed) {
            return;
        }
        if (string == null && nArray == null && n2 == 0 && n3 == 0 && n4 == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        if (this.composedText == null) {
            this.composedText = new StringBuffer(64);
            this.rawFeedbacks = new IntBuffer(64);
        }
        if (n3 > 0) {
            if (string == null && nArray != null) {
                this.rawFeedbacks.replace(n2, nArray);
            } else if (n3 == this.composedText.length()) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            } else if (this.composedText.length() > 0) {
                if (n2 + n3 < this.composedText.length()) {
                    String string2 = this.composedText.toString().substring(n2 + n3, this.composedText.length());
                    this.composedText.setLength(n2);
                    this.composedText.append(string2);
                } else {
                    this.composedText.setLength(n2);
                }
                this.rawFeedbacks.remove(n2, n3);
            }
        }
        if (string != null) {
            this.composedText.insert(n2, string);
            if (nArray != null) {
                this.rawFeedbacks.insert(n2, nArray);
            }
        }
        if (this.composedText.length() == 0) {
            this.composedText = null;
            this.rawFeedbacks = null;
            if (this.committedText != null) {
                this.dispatchCommittedText(this.committedText, l2);
                this.committedText = null;
                return;
            }
            this.postInputMethodEvent(1100, null, 0, null, null, l2);
            return;
        }
        if (this.committedText != null) {
            n7 = this.committedText.length();
            attributedString = new AttributedString(this.committedText + this.composedText);
            this.committedText = null;
        } else {
            n7 = 0;
            attributedString = new AttributedString(this.composedText.toString());
        }
        int n8 = 0;
        int n9 = 0;
        TextHitInfo textHitInfo = null;
        this.rawFeedbacks.rewind();
        int n10 = this.rawFeedbacks.getNext();
        this.rawFeedbacks.unget();
        while ((n6 = this.rawFeedbacks.getNext()) != -1) {
            if (n9 == 0 && (n9 = n6 & 0x700) != 0) {
                int n11 = this.rawFeedbacks.getOffset() - 1;
                textHitInfo = n9 == 512 ? TextHitInfo.leading(n11) : TextHitInfo.trailing(n11);
            }
            if (n10 == (n6 &= 0xFFFFF8FF)) continue;
            this.rawFeedbacks.unget();
            n5 = this.rawFeedbacks.getOffset();
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n10), n7 + n8, n7 + n5);
            n8 = n5;
            n10 = n6;
        }
        n5 = this.rawFeedbacks.getOffset();
        if (n5 >= 0) {
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n10), n7 + n8, n7 + n5);
        }
        this.postInputMethodEvent(1100, attributedString.getIterator(), n7, TextHitInfo.leading(n4), textHitInfo, l2);
    }

    void flushText() {
        String string;
        String string2 = string = this.committedText != null ? this.committedText : "";
        if (this.composedText != null) {
            string = string + this.composedText.toString();
        }
        if (!string.equals("")) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null, EventQueue.getMostRecentEventTime());
            this.composedText = null;
            this.committedText = null;
        }
    }

    protected synchronized void disposeImpl() {
        this.disposeXIC();
        this.awtLock();
        this.composedText = null;
        this.committedText = null;
        this.rawFeedbacks = null;
        this.awtUnlock();
        this.awtFocussedComponent = null;
        this.xicFocussedComponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl2 = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    bl2 = true;
                    this.disposed = true;
                }
            }
        }
        if (bl2) {
            this.disposeImpl();
        }
    }

    public Object getControlObject() {
        return null;
    }

    public synchronized void removeNotify() {
        this.dispose();
    }

    public void setCompositionEnabled(boolean bl2) {
        this.setCompositionEnabledNative(bl2);
    }

    public boolean isCompositionEnabled() {
        return this.isCompositionEnabledNative();
    }

    public void endComposition() {
        if (this.disposed) {
            return;
        }
        boolean bl2 = false;
        if (this.compositionEnableSupported) {
            try {
                bl2 = this.isCompositionEnabled();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
        if (this.haveActiveClient() && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            this.needCompositionEnable = bl2;
            return;
        }
        String string = this.resetXIC();
        this.needResetXIC = false;
        this.awtLock();
        this.composedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null);
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string);
        }
        this.awtUnlock();
        if (this.compositionEnableSupported && bl2) {
            try {
                this.setCompositionEnabled(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n2) {
        InputMethodHighlight inputMethodHighlight;
        switch (n2) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    protected native String resetXIC();

    private native void disposeXIC();

    private native void setCompositionEnabledNative(boolean var1);

    private native boolean isCompositionEnabledNative();

    private native void turnoffStatusWindow();

    static {
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Comparable<Float>> hashMap = new HashMap<TextAttribute, Comparable<Float>>(1);
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
        X11InputMethod.initIDs();
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int n2) {
            this.intArray = new int[n2];
            this.size = 0;
            this.index = 0;
        }

        void insert(int n2, int[] nArray) {
            int n3 = this.size + nArray.length;
            if (this.intArray.length < n3) {
                int[] nArray2 = new int[n3 * 2];
                System.arraycopy(this.intArray, 0, nArray2, 0, this.size);
                this.intArray = nArray2;
            }
            System.arraycopy(this.intArray, n2, this.intArray, n2 + nArray.length, this.size - n2);
            System.arraycopy(nArray, 0, this.intArray, n2, nArray.length);
            this.size += nArray.length;
            if (this.index > n2) {
                this.index = n2;
            }
        }

        void remove(int n2, int n3) {
            if (n2 + n3 != this.size) {
                System.arraycopy(this.intArray, n2 + n3, this.intArray, n2, this.size - n2 - n3);
            }
            this.size -= n3;
            if (this.index > n2) {
                this.index = n2;
            }
        }

        void replace(int n2, int[] nArray) {
            System.arraycopy(nArray, 0, this.intArray, n2, nArray.length);
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void rewind() {
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }

        int getOffset() {
            return this.index;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.size) {
                stringBuffer.append(this.intArray[n2++]);
                if (n2 >= this.size) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
    }
}

