/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.util.Locale;
import sun.font.CMap;
import sun.font.CharToGlyphMapper;
import sun.font.FontManager;
import sun.font.TrueTypeFont;

public class TrueTypeGlyphMapper
extends CharToGlyphMapper {
    static final char REVERSE_SOLIDUS = '\\';
    static final char JA_YEN = '\u00a5';
    static final char JA_FULLWIDTH_TILDE_CHAR = '\uff5e';
    static final char JA_WAVE_DASH_CHAR = '\u301c';
    static final boolean isJAlocale = Locale.JAPAN.equals(Locale.getDefault());
    private final boolean needsJAremapping;
    private boolean remapJAWaveDash;
    TrueTypeFont font;
    CMap cmap;
    int numGlyphs;

    public TrueTypeGlyphMapper(TrueTypeFont trueTypeFont) {
        this.font = trueTypeFont;
        try {
            this.cmap = CMap.initialize(trueTypeFont);
        }
        catch (Exception exception) {
            this.cmap = null;
        }
        if (this.cmap == null && this.cmap == null) {
            if (FontManager.logging) {
                FontManager.logger.severe("Null Cmap for " + trueTypeFont + "substituting for this font");
            }
            FontManager.deRegisterBadFont(trueTypeFont);
            this.cmap = CMap.theNullCmap;
        }
        this.missingGlyph = 0;
        ByteBuffer byteBuffer = trueTypeFont.getTableBuffer(1835104368);
        this.numGlyphs = byteBuffer.getChar(4);
        if (FontManager.isSolaris && isJAlocale && trueTypeFont.supportsJA()) {
            this.needsJAremapping = true;
            if (FontManager.isSolaris8 && this.cmap.getGlyph(12316) == this.missingGlyph) {
                this.remapJAWaveDash = true;
            }
        } else {
            this.needsJAremapping = false;
        }
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private final char remapJAChar(char c2) {
        switch (c2) {
            case '\\': {
                return '\u00a5';
            }
            case '\u301c': {
                if (!this.remapJAWaveDash) break;
                return '\uff5e';
            }
        }
        return c2;
    }

    private final int remapJAIntChar(int n2) {
        switch (n2) {
            case 92: {
                return 165;
            }
            case 12316: {
                if (!this.remapJAWaveDash) break;
                return 65374;
            }
        }
        return n2;
    }

    public int charToGlyph(char c2) {
        if (this.needsJAremapping) {
            c2 = this.remapJAChar(c2);
        }
        char c3 = this.cmap.getGlyph(c2);
        if (this.font.useNatives && c3 < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c3] = c2;
        }
        return c3;
    }

    public int charToGlyph(int n2) {
        if (this.needsJAremapping) {
            n2 = this.remapJAIntChar(n2);
        }
        char c2 = this.cmap.getGlyph(n2);
        if (this.font.useNatives && c2 < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c2] = (char)n2;
        }
        return c2;
    }

    public void charsToGlyphs(int n2, int[] nArray, int[] nArray2) {
        if (this.cmap != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray2[i2] = this.needsJAremapping ? (int)this.cmap.getGlyph(this.remapJAIntChar(nArray[i2])) : (int)this.cmap.getGlyph(nArray[i2]);
                if (!this.font.useNatives || nArray2[i2] >= this.font.glyphToCharMap.length) continue;
                this.font.glyphToCharMap[nArray2[i2]] = (char)nArray[i2];
            }
        }
    }

    public void charsToGlyphs(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            int n3 = this.needsJAremapping ? this.remapJAChar(cArray[i2]) : cArray[i2];
            if (n3 >= 55296 && n3 <= 56319 && i2 < n2 - 1 && (c2 = cArray[i2 + 1]) >= '\udc00' && c2 <= '\udfff') {
                n3 = (n3 - 55296) * 1024 + c2 - 56320 + 65536;
                nArray[i2] = this.cmap.getGlyph(n3);
                nArray[++i2] = 65535;
                continue;
            }
            nArray[i2] = this.cmap.getGlyph(n3);
            if (!this.font.useNatives || nArray[i2] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[nArray[i2]] = (char)n3;
        }
    }

    public boolean charsToGlyphsNS(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            int n3 = this.needsJAremapping ? this.remapJAChar(cArray[i2]) : cArray[i2];
            if (n3 >= 55296 && n3 <= 56319 && i2 < n2 - 1 && (c2 = cArray[i2 + 1]) >= '\udc00' && c2 <= '\udfff') {
                n3 = (n3 - 55296) * 1024 + c2 - 56320 + 65536;
                nArray[i2 + 1] = 65535;
            }
            nArray[i2] = this.cmap.getGlyph(n3);
            if (this.font.useNatives && nArray[i2] < this.font.glyphToCharMap.length) {
                this.font.glyphToCharMap[nArray[i2]] = (char)n3;
            }
            if (n3 < 1424) continue;
            if (n3 <= 1535) {
                return true;
            }
            if (n3 >= 1536 && n3 <= 1791) {
                return true;
            }
            if (n3 >= 2304 && n3 <= 3455) {
                return true;
            }
            if (n3 >= 3584 && n3 <= 3711) {
                return true;
            }
            if (n3 >= 8204 && n3 <= 8205) {
                return true;
            }
            if (n3 >= 8234 && n3 <= 8238) {
                return true;
            }
            if (n3 >= 8298 && n3 <= 8303) {
                return true;
            }
            if (n3 < 65536) continue;
            ++i2;
        }
        return false;
    }
}

