/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.FontConfiguration;
import sun.font.CompositeFontDescriptor;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements FontSupport {
    public static boolean isLinux;
    public static boolean isSolaris;
    protected static boolean noType1Font;
    private static Font defaultFont;
    private static String lucidaSansFileName;
    public static final String lucidaFontName = "Lucida Sans Regular";
    public static boolean debugFonts;
    protected static Logger logger;
    private static ArrayList badFonts;
    public static String jreLibDirName;
    public static String jreFontDirName;
    private FontConfiguration fontConfig;
    protected String fontPath;
    private boolean loadedAllFonts = false;
    protected HashSet registeredFontFiles = new HashSet();
    public static String eudcFontFileName;
    protected GraphicsDevice[] screens;
    private Font[] allFonts;
    private String[] allFamilies;
    private Locale lastDefaultLocale;
    public static final TTFilter ttFilter;
    public static final T1Filter t1Filter;

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                Object object;
                String string2 = System.getProperty("os.name");
                if ("Linux".equals(string2)) {
                    isLinux = true;
                } else if ("SunOS".equals(string2)) {
                    isSolaris = true;
                }
                String string3 = System.getProperty("sun.java2d.debugfonts");
                if (string3 != null && !string3.equals("false")) {
                    debugFonts = true;
                    logger = Logger.getLogger("sun.java2d");
                    if (string3.equals("warning")) {
                        logger.setLevel(Level.WARNING);
                    } else if (string3.equals("severe")) {
                        logger.setLevel(Level.SEVERE);
                    }
                }
                noType1Font = "true".equals(System.getProperty("sun.java2d.noType1Font"));
                jreLibDirName = System.getProperty("java.home", "") + File.separator + "lib";
                jreFontDirName = jreLibDirName + File.separator + "fonts";
                if (SunGraphicsEnvironment.this.useAbsoluteFontFileNames()) {
                    lucidaSansFileName = jreFontDirName + File.separator + "LucidaSansRegular.ttf";
                } else {
                    lucidaSansFileName = "LucidaSansRegular.ttf";
                }
                File file = new File(jreFontDirName + File.separator + "badfonts.txt");
                if (file.exists()) {
                    object = null;
                    try {
                        badFonts = new ArrayList();
                        object = new FileInputStream(file);
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (debugFonts) {
                                logger.warning("read bad font: " + string);
                            }
                            badFonts.add(string);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
                if (isLinux) {
                    SunGraphicsEnvironment.this.registerFontDir(jreFontDirName);
                }
                SunGraphicsEnvironment.this.registerFontsInDir(jreFontDirName, true, 2, true, false);
                SunGraphicsEnvironment.this.registerJREFontsWithPlatform(jreFontDirName);
                SunGraphicsEnvironment.this.fontConfig = SunGraphicsEnvironment.this.createFontConfiguration();
                SunGraphicsEnvironment.this.getPlatformFontPathFromFontConfig();
                object = SunGraphicsEnvironment.this.fontConfig.getExtraFontPath();
                boolean bl2 = false;
                boolean bl3 = false;
                string = System.getProperty("sun.java2d.fontpath");
                if (string != null) {
                    if (string.startsWith("prepend:")) {
                        bl2 = true;
                        string = string.substring("prepend:".length());
                    } else if (string.startsWith("append:")) {
                        bl3 = true;
                        string = string.substring("append:".length());
                    }
                }
                if (debugFonts) {
                    logger.info("JRE font directory: " + jreFontDirName);
                    logger.info("Extra font path: " + (String)object);
                    logger.info("Debug font path: " + string);
                }
                if (string != null) {
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(noType1Font);
                    if (object != null) {
                        SunGraphicsEnvironment.this.fontPath = (String)object + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                    }
                    SunGraphicsEnvironment.this.fontPath = bl3 ? SunGraphicsEnvironment.this.fontPath + File.pathSeparator + string : (bl2 ? string + File.pathSeparator + SunGraphicsEnvironment.this.fontPath : string);
                    SunGraphicsEnvironment.this.registerFontDirs(SunGraphicsEnvironment.this.fontPath);
                } else if (object != null) {
                    SunGraphicsEnvironment.this.registerFontDirs((String)object);
                }
                if (isSolaris && Locale.JAPAN.equals(Locale.getDefault())) {
                    SunGraphicsEnvironment.this.registerFontDir("/usr/openwin/lib/locale/ja/X11/fonts/TT");
                }
                SunGraphicsEnvironment.this.initCompositeFonts(SunGraphicsEnvironment.this.fontConfig, null);
                defaultFont = new Font("Dialog", 0, 12);
                return null;
            }
        });
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n2 = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                graphicsDeviceArray[i2] = this.makeScreenDevice(i2);
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = SurfaceData.getDestSurfaceData(bufferedImage);
        return new SunGraphics2D(surfaceData, Color.white, Color.black, defaultFont);
    }

    protected String getPlatformFontPath(boolean bl2) {
        return FontManager.getFontPath(bl2);
    }

    protected boolean useAbsoluteFontFileNames() {
        return true;
    }

    public String getDefaultFontFile() {
        return lucidaSansFileName;
    }

    public String getDefaultFontFaceName() {
        return lucidaFontName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFonts() {
        if (this.loadedAllFonts) {
            return;
        }
        String string = lucidaFontName;
        synchronized (lucidaFontName) {
            if (debugFonts) {
                Thread.dumpStack();
                logger.info("SunGraphicsEnvironment.loadFonts() called");
            }
            FontManager.initialiseDeferredFonts();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SunGraphicsEnvironment.this.fontPath == null) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(noType1Font);
                        SunGraphicsEnvironment.this.registerFontDirs(SunGraphicsEnvironment.this.fontPath);
                    }
                    if (SunGraphicsEnvironment.this.fontPath != null) {
                        SunGraphicsEnvironment.this.registerFontsOnPath(SunGraphicsEnvironment.this.fontPath, false, 6, false, true);
                    }
                    SunGraphicsEnvironment.this.loadedAllFonts = true;
                    return null;
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Font[] getAllFonts() {
        Font[] fontArray;
        if (this.allFonts == null) {
            int n2;
            Object[] objectArray;
            this.loadFonts();
            fontArray = new TreeMap();
            Font2D[] font2DArray = FontManager.getRegisteredFonts();
            for (int i2 = 0; i2 < font2DArray.length; ++i2) {
                if (font2DArray[i2] instanceof NativeFont) continue;
                fontArray.put(font2DArray[i2].getFontName(null), font2DArray[i2]);
            }
            String[] stringArray = null;
            if (fontArray.size() > 0) {
                stringArray = new String[fontArray.size()];
                objectArray = fontArray.keySet().toArray();
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    stringArray[n2] = (String)objectArray[n2];
                }
            }
            objectArray = new Font[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                objectArray[n2] = new Font(stringArray[n2], 0, 1);
                Font2D font2D = (Font2D)fontArray.get(stringArray[n2]);
                FontManager.setFont2D((Font)objectArray[n2], font2D.handle);
            }
            this.allFonts = objectArray;
        }
        fontArray = new Font[this.allFonts.length];
        System.arraycopy(this.allFonts, 0, fontArray, 0, this.allFonts.length);
        return fontArray;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        Object object;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.allFamilies != null && this.lastDefaultLocale != null && locale.equals(this.lastDefaultLocale)) {
            String[] stringArray = new String[this.allFamilies.length];
            System.arraycopy(this.allFamilies, 0, stringArray, 0, this.allFamilies.length);
            return stringArray;
        }
        this.loadFonts();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        String string = "Serif";
        treeMap.put(string.toLowerCase(), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(), string);
        PhysicalFont[] physicalFontArray = FontManager.getPhysicalFonts();
        for (int i2 = 0; i2 < physicalFontArray.length; ++i2) {
            if (physicalFontArray[i2] instanceof NativeFont) continue;
            object = physicalFontArray[i2].getFamilyName(locale);
            treeMap.put(((String)object).toLowerCase(locale), object);
        }
        String[] stringArray = new String[treeMap.size()];
        object = treeMap.keySet().toArray();
        for (int i3 = 0; i3 < ((Object[])object).length; ++i3) {
            stringArray[i3] = (String)treeMap.get(object[i3]);
        }
        if (locale.equals(Locale.getDefault())) {
            this.lastDefaultLocale = locale;
            this.allFamilies = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.allFamilies, 0, this.allFamilies.length);
        }
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    protected String getFileNameFromPlatformName(String string) {
        return this.fontConfig.getFileNameFromPlatformName(string);
    }

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    protected void registerJREFontsWithPlatform(String string) {
    }

    public void register1dot0Fonts() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = "/usr/openwin/lib/X11/fonts/Type1";
                SunGraphicsEnvironment.this.registerFontsInDir(string, true, 4, false, false);
                return null;
            }
        });
    }

    protected void registerFontDirs(String string) {
    }

    public void registerFontsInDir(String string) {
        this.registerFontsInDir(string, true, 2, true, false);
    }

    private void registerFontsInDir(String string, boolean bl2, int n2, boolean bl3, boolean bl4) {
        File file = new File(string);
        this.addDirFonts(string, file, ttFilter, 0, bl2, n2 == 6 ? 3 : n2, bl3, bl4);
        this.addDirFonts(string, file, t1Filter, 1, bl2, n2 == 6 ? 4 : n2, bl3, bl4);
    }

    private void registerFontsOnPath(String string, boolean bl2, int n2, boolean bl3, boolean bl4) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                this.registerFontsInDir(stringTokenizer.nextToken(), bl2, n2, bl3, bl4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected void registerFontFile(String string, String[] stringArray, int n2, boolean bl2) {
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        int n3 = ttFilter.accept(null, string) ? 0 : (t1Filter.accept(null, string) ? 1 : 5);
        this.registeredFontFiles.add(string);
        if (bl2) {
            FontManager.registerDeferredFont(string, string, stringArray, n3, false, n2);
        } else {
            FontManager.registerFontFile(string, stringArray, n3, false, n2);
        }
    }

    protected void registerFontDir(String string) {
    }

    protected String[] getNativeNames(String string, String string2) {
        return null;
    }

    private void addDirFonts(String string, File file, FilenameFilter filenameFilter, int n2, boolean bl2, int n3, boolean bl3, boolean bl4) {
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        String[][] stringArray3 = new String[stringArray.length][];
        int n4 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file2 = new File(file, stringArray[i2]);
            String string2 = null;
            if (bl4) {
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string2 == null) {
                string2 = string + File.separator + stringArray[i2];
            }
            if (this.registeredFontFiles.contains(string2)) continue;
            if (badFonts != null && badFonts.contains(string2)) {
                if (!debugFonts) continue;
                logger.warning("skip bad font " + string2);
                continue;
            }
            this.registeredFontFiles.add(string2);
            if (debugFonts && logger.isLoggable(Level.INFO)) {
                String string3 = "Registering font " + string2;
                String[] stringArray4 = this.getNativeNames(string2, null);
                if (stringArray4 == null) {
                    string3 = string3 + " with no native name";
                } else {
                    string3 = string3 + " with native name(s) " + stringArray4[0];
                    for (int i3 = 1; i3 < stringArray4.length; ++i3) {
                        string3 = string3 + ", " + stringArray4[i3];
                    }
                }
                logger.info(string3);
            }
            stringArray2[n4] = string2;
            stringArray3[n4++] = this.getNativeNames(string2, null);
        }
        FontManager.registerFonts(stringArray2, stringArray3, n4, n2, bl2, n3, bl3);
    }

    protected abstract FontConfiguration createFontConfiguration();

    public abstract FontConfiguration createFontConfiguration(boolean var1, boolean var2);

    private void initCompositeFonts(FontConfiguration fontConfiguration, Hashtable hashtable) {
        String[] stringArray;
        Object object;
        int n2 = fontConfiguration.getNumberCoreFonts();
        String[] stringArray2 = fontConfiguration.getPlatformFontNames();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string = stringArray2[i2];
            object = this.getFileNameFromPlatformName(string);
            stringArray = null;
            if (object == null) {
                object = string;
            } else {
                if (i2 < n2) {
                    this.addFontToPlatformFontPath(string);
                }
                stringArray = this.getNativeNames((String)object, string);
            }
            this.registerFontFile((String)object, stringArray, 2, true);
        }
        this.registerPlatformFontsUsedByFontConfiguration();
        CompositeFontDescriptor[] compositeFontDescriptorArray = fontConfiguration.get2DCompositeFontInfo();
        for (int i3 = 0; i3 < compositeFontDescriptorArray.length; ++i3) {
            object = compositeFontDescriptorArray[i3];
            stringArray = ((CompositeFontDescriptor)object).getComponentFileNames();
            String[] stringArray3 = ((CompositeFontDescriptor)object).getComponentFaceNames();
            if (hashtable != null) {
                FontManager.registerCompositeFont(((CompositeFontDescriptor)object).getFaceName(), stringArray, stringArray3, ((CompositeFontDescriptor)object).getCoreComponentCount(), ((CompositeFontDescriptor)object).getExclusionRanges(), ((CompositeFontDescriptor)object).getExclusionRangeLimits(), true, hashtable);
            } else {
                FontManager.registerCompositeFont(((CompositeFontDescriptor)object).getFaceName(), stringArray, stringArray3, ((CompositeFontDescriptor)object).getCoreComponentCount(), ((CompositeFontDescriptor)object).getExclusionRanges(), ((CompositeFontDescriptor)object).getExclusionRangeLimits(), true);
            }
            if (!debugFonts) continue;
            logger.info("registered " + ((CompositeFontDescriptor)object).getFaceName());
        }
    }

    protected void addFontToPlatformFontPath(String string) {
    }

    protected void registerPlatformFontsUsedByFontConfiguration() {
    }

    public static boolean isLogicalFont(Font font) {
        return FontConfiguration.isLogicalFontFamilyName(font.getFamily());
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfig;
    }

    public static Rectangle getUsableBounds(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontManager.fontSupportsDefaultEncoding(font);
    }

    public static void useAlternateFontforJALocales() {
        FontManager.useAlternateFontforJALocales();
    }

    public void createCompositeFonts(Hashtable hashtable, boolean bl2, boolean bl3) {
        FontConfiguration fontConfiguration = this.createFontConfiguration(bl2, bl3);
        this.initCompositeFonts(fontConfiguration, hashtable);
    }

    protected void getPlatformFontPathFromFontConfig() {
    }

    static {
        debugFonts = false;
        logger = null;
        ttFilter = new TTFilter();
        t1Filter = new T1Filter();
    }

    public static class T1Filter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            int n2 = string.length() - 4;
            if (n2 <= 0) {
                return false;
            }
            return string.startsWith(".pfa", n2) || string.startsWith(".pfb", n2) || string.startsWith(".PFA", n2) || string.startsWith(".PFB", n2);
        }
    }

    public static class TTFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            int n2 = string.length() - 4;
            if (n2 <= 0) {
                return false;
            }
            return string.startsWith(".ttf", n2) || string.startsWith(".TTF", n2) || string.startsWith(".ttc", n2) || string.startsWith(".TTC", n2);
        }
    }
}

