/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.vfw.VFWCapture;
import com.sun.media.util.WindowUtil;
import com.sun.media.vfw.BitMapInfo;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.VideoFormat;

public class VFWManual
extends Frame {
    CaptureDeviceInfo[] devices = null;
    int currentID = -1;
    static /* synthetic */ Class array$B;

    public VFWManual() {
        super("Register VFW Caputure Devices");
        this.setLayout(new FlowLayout());
        int nDevices = 0;
        this.removeCurrentDevices();
        int i2 = 0;
        while (i2 < 10) {
            String name = VFWCapture.capGetDriverDescriptionName(i2);
            if (name != null && name.length() > 1) {
                Button device = new Button(name);
                this.add(device);
                device.addActionListener(new DBListener(i2));
                ++nDevices;
            }
            ++i2;
        }
        this.devices = new CaptureDeviceInfo[nDevices];
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (VFWManual.this.currentID != -1) {
                    System.err.println("Need to close other window first");
                    return;
                }
                VFWManual.this.dispose();
                System.exit(0);
            }
        });
    }

    private void removeCurrentDevices() {
        Vector deviceList = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
        Enumeration enumeration = deviceList.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            String name = cdi.getName();
            if (!name.startsWith("vfw:")) continue;
            CaptureDeviceManager.removeDevice(cdi);
        }
    }

    public void createDialog(int id) {
        if (this.currentID == id) {
            return;
        }
        this.currentID = id;
        Thread t = new Thread(new Runnable(){

            public void run() {
                FormatsDialog fd = new FormatsDialog(VFWManual.this.currentID);
                fd.setVisible(true);
                CaptureDeviceInfo cdi = fd.getDeviceInfo();
                if (cdi != null) {
                    System.err.println("CaptureDeviceInfo = " + cdi.getName() + " " + cdi.getLocator());
                }
                VFWManual.this.currentID = -1;
            }
        });
        t.start();
    }

    public static void main(String[] args) {
        VFWManual m2 = new VFWManual();
        m2.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DBListener
    implements ActionListener {
        int id;

        public DBListener(int id) {
            this.id = id;
        }

        public void actionPerformed(ActionEvent ae) {
            VFWManual.this.createDialog(this.id);
        }
    }

    class FormatsDialog
    extends Frame {
        int id;
        Button bVideoFormat;
        Button bDone;
        Button bCancel;
        Vector formats = new Vector();
        Frame capFrame;
        int capHandle;
        Integer lock = new Integer(1);
        boolean finished = false;
        boolean needVideoFormatDialog = false;

        public FormatsDialog(int id) {
            super(VFWCapture.capGetDriverDescriptionName(id));
            this.id = id;
            this.setLayout(new FlowLayout());
            this.bVideoFormat = new Button("VideoFormat Dialog");
            this.bDone = new Button("Done");
            this.bCancel = new Button("Cancel");
            this.capFrame = new Frame("CaptureWindow");
            this.capFrame.setBounds(0, 0, 380, 280);
            this.capFrame.addNotify();
            this.capFrame.setVisible(false);
            this.capHandle = VFWCapture.capCreateCaptureWindow("Test", WindowUtil.getWindowHandle(this.capFrame), 0, 0, 320, 240, VFWCapture.getNextID());
            if (this.capHandle == 0) {
                this.capFrame.dispose();
                throw new Error("Could not create capture window");
            }
            VFWCapture.capDriverConnect(this.capHandle, id);
            this.add(this.bVideoFormat);
            this.add(this.bDone);
            this.add(this.bCancel);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowClosing(WindowEvent we) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bDone.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent ae) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bCancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent ae) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bVideoFormat.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent ae) {
                    this.this$1.needVideoFormatDialog = true;
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.lock.notify();
                    }
                }
            });
        }

        public void mydispose() {
            VFWCapture.capDriverDisconnect(this.capHandle);
            this.capFrame.dispose();
            this.dispose();
            System.err.println("Disconnected driver");
        }

        public void doVideoFormatDialog() {
            VFWCapture.capDlgVideoFormat(this.capHandle);
            BitMapInfo bmi = new BitMapInfo();
            VFWCapture.capGetVideoFormat(this.capHandle, bmi);
            VideoFormat vf = bmi.createVideoFormat(array$B == null ? (array$B = VFWManual.class$("[B")) : array$B);
            System.err.println("Format = " + vf);
            Enumeration enumeration = this.formats.elements();
            while (enumeration.hasMoreElements()) {
                Format f2 = (Format)enumeration.nextElement();
                if (!f2.equals(vf)) continue;
                return;
            }
            this.formats.addElement(vf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaptureDeviceInfo getDeviceInfo() {
            try {
                while (!this.finished) {
                    Integer n2 = this.lock;
                    synchronized (n2) {
                        this.lock.wait();
                    }
                    if (!this.needVideoFormatDialog) continue;
                    this.needVideoFormatDialog = false;
                    this.doVideoFormatDialog();
                }
            }
            catch (InterruptedException ie) {
                this.mydispose();
                return null;
            }
            String name = "vfw:" + VFWCapture.capDriverGetName(this.capHandle) + ":" + this.id;
            String locator = "vfw://" + this.id;
            this.mydispose();
            if (this.formats == null || this.formats.size() < 1) {
                return null;
            }
            Format[] farray = new Format[this.formats.size()];
            Enumeration enumeration = this.formats.elements();
            int i2 = 0;
            while (enumeration.hasMoreElements()) {
                Format f2 = (Format)enumeration.nextElement();
                farray[i2++] = f2;
            }
            CaptureDeviceInfo cdi = new CaptureDeviceInfo(name, new MediaLocator(locator), farray);
            CaptureDeviceManager.addDevice(cdi);
            try {
                CaptureDeviceManager.commit();
                System.err.println("VFWManual: Committed ok");
            }
            catch (IOException ioe) {
                System.err.println("VFWManual: error committing cdm");
            }
            return cdi;
        }
    }
}

