/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MpegAudio;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeDecoder
extends AudioCodec {
    private int pendingDataSize = 0;
    private static final int OUTSIZE = 32768;
    private byte[] pendingData = new byte[131072];
    private MpegAudio mpa;
    private int nativeData = 0;
    private boolean expectingSameInputBuffer = false;
    private long accumTS = 0L;
    private AudioFormat aFormat = null;
    int[] inRead = new int[1];
    int[] inReq = new int[1];
    int[] outWritten = new int[1];

    public NativeDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Layer 2 Decoder";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            AudioFormat output = new AudioFormat("LINEAR", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), 1, 1);
            this.outputFormats = new Format[]{output};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.nativeData != 0) {
            this.close();
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpa");
            this.mpa = new MpegAudio();
            this.nativeData = MpegAudio.nOpen(new int[1]);
            if (this.nativeData == 0) {
                throw new ResourceUnavailableException("could not open " + this.getName());
            }
            this.pendingDataSize = 0;
            this.expectingSameInputBuffer = false;
            this.accumTS = 0L;
            this.aFormat = (AudioFormat)this.outputFormat;
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.nativeData != 0) {
            MpegAudio.nClose(this.nativeData);
            this.nativeData = 0;
        }
    }

    public synchronized void reset() {
        if (this.nativeData != 0) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                Log.error("MP2 Decoder: " + rue);
            }
        }
    }

    public synchronized int process(Buffer in, Buffer out) {
        boolean inputEOM = false;
        if (this.isEOM(in)) {
            if (this.pendingDataSize == 0) {
                this.propagateEOM(out);
                return 0;
            }
            inputEOM = true;
        }
        Object inObject = in.getData();
        Object outObject = out.getData();
        if (outObject == null) {
            outObject = new byte[32768];
            out.setData(outObject);
        }
        if (!(inObject instanceof byte[]) || !(outObject instanceof byte[])) {
            return 1;
        }
        byte[] inData = (byte[])inObject;
        byte[] outData = (byte[])outObject;
        int inOffset = in.getOffset();
        int inLength = in.getLength();
        int outdataSize = outData.length;
        int outOffset = 0;
        int pendingDataOffset = 0;
        if (!this.expectingSameInputBuffer) {
            System.arraycopy(inData, inOffset, this.pendingData, this.pendingDataSize, inLength);
            this.pendingDataSize += inLength;
        }
        this.inReq[0] = 21;
        if (this.nativeData != 0) {
            while (outOffset + 5000 <= outdataSize && this.pendingDataSize >= this.inReq[0]) {
                boolean returnVal = MpegAudio.nConvert(this.nativeData, this.pendingData, pendingDataOffset, this.pendingDataSize, outData, outOffset, outdataSize - outOffset, this.inRead, this.outWritten, pendingDataOffset, this.inReq);
                if (returnVal) {
                    if (this.inRead[0] > this.pendingDataSize) break;
                    outOffset += this.outWritten[0];
                    pendingDataOffset += this.inRead[0];
                    this.pendingDataSize -= this.inRead[0];
                    if (this.inReq[0] == 0) {
                        this.inReq[0] = 21;
                    }
                    if (this.pendingDataSize >= this.inRead[0] + 9) continue;
                    break;
                }
                if (outOffset > 0) break;
                this.pendingDataSize = 0;
                if (inputEOM) {
                    outOffset = 0;
                    break;
                }
                return 1;
            }
        }
        if (pendingDataOffset != 0) {
            System.arraycopy(this.pendingData, pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
        }
        out.setLength(outOffset);
        out.setFormat(this.outputFormat);
        if (this.aFormat != null && this.accumTS != 0L && in.getTimeStamp() > 0L) {
            out.setTimeStamp(in.getTimeStamp() + this.aFormat.computeDuration(this.accumTS));
        }
        if (inputEOM) {
            if (outOffset == 0) {
                this.pendingDataSize = 0;
                this.propagateEOM(out);
                return 0;
            }
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)out.getLength();
            return 2;
        }
        if (this.pendingDataSize > 1024) {
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)out.getLength();
            return 2;
        }
        this.expectingSameInputBuffer = false;
        this.accumTS = 0L;
        return 0;
    }

    static {
        OUTSIZE = 32768;
    }
}

