/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.processor.rtsp;

import com.sun.media.BasicProcessor;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.content.rtsp.RtspUtil;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicProcessor
implements ReceiveStreamListener {
    private final int INITIALIZED = 0;
    private final int REALIZED = 1;
    private final int PLAYING = 2;
    private final int PAUSING = 3;
    private DataSource[] data_sources;
    Processor processor = null;
    Format[] formats = null;
    Vector locators = null;
    Object dataLock = new Object();
    boolean dataReady = false;
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean first_pass = true;
    RtspUtil rtspUtil;
    String sessionError = "cannot create and initialize the RTP Session.";

    public Handler() {
        this.framePositioning = false;
        this.rtspUtil = new RtspUtil(this);
        this.locators = new Vector();
    }

    protected synchronized boolean doConfigure() {
        boolean configured = super.doConfigure();
        if (configured) {
            configured = this.initRtspSession();
        }
        return configured;
    }

    private boolean initRtspSession() {
        boolean realized = false;
        MediaLocator ml = (MediaLocator)this.locators.elementAt(0);
        this.rtspUtil.setUrl(ml.toString());
        String ipAddress = this.rtspUtil.getServerIpAddress();
        if (ipAddress == null) {
            System.out.println("Invalid server address.");
            realized = false;
        } else {
            this.rtspUtil.setUrl(ml.toString());
            realized = this.rtspUtil.createConnection();
            if (realized) {
                realized = this.rtspUtil.rtspSetup();
                try {
                    InetAddress destaddr = InetAddress.getByName(ipAddress);
                    int[] server_ports = this.rtspUtil.getServerPorts();
                    int i2 = 0;
                    while (i2 < this.rtspUtil.getNumberOfTracks()) {
                        SessionAddress remoteAddress = new SessionAddress(destaddr, server_ports[i2]);
                        this.rtspUtil.getRTPManager(i2).addTarget(remoteAddress);
                        BufferControl bc = (BufferControl)this.rtspUtil.getRTPManager(i2).getControl("javax.media.control.BufferControl");
                        String mediaType = this.rtspUtil.getMediaType(i2);
                        if (mediaType.equals("audio")) {
                            bc.setBufferLength(250L);
                            bc.setMinimumThreshold(125L);
                        } else if (mediaType.equals("video")) {
                            bc.setBufferLength(1500L);
                            bc.setMinimumThreshold(250L);
                        }
                        ++i2;
                    }
                }
                catch (Exception e2) {
                    Log.error(e2.getMessage());
                    return realized;
                }
            }
        }
        if (realized) {
            this.state = 1;
            int size = this.rtspUtil.getNumberOfTracks();
            this.data_sources = new DataSource[size];
            this.formats = new Format[size];
            if (!this.rtspUtil.rtspStart()) {
                if (this.first_pass && this.rtspUtil.getStatusCode() == 454) {
                    this.first_pass = false;
                    return this.initRtspSession();
                }
                return false;
            }
            this.waitForData();
        }
        return realized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForData() {
        try {
            Object object = this.dataLock;
            synchronized (object) {
                while (!this.dataReady) {
                    this.dataLock.wait();
                }
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return this.dataReady;
    }

    protected void completeConfigure() {
        this.state = 180;
        super.completeConfigure();
    }

    protected void doFailedConfigure() {
        this.closeSessions();
        super.doFailedConfigure();
    }

    private void closeSessions() {
        RTPManager[] mgrs = this.rtspUtil.getRTPManagers();
        int i2 = 0;
        while (i2 < mgrs.length) {
            if (mgrs[i2] != null) {
                mgrs[i2].removeTargets("Closing session from the RTP Handler");
                mgrs[i2].dispose();
            }
            mgrs[i2] = null;
            ++i2;
        }
    }

    protected boolean doRealize() {
        return this.waitForRealize(this.processor);
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doFailedRealize() {
        this.closeSessions();
        super.doFailedRealize();
    }

    protected void doStart() {
        super.doStart();
        this.waitForStart(this.processor);
    }

    protected void doStop() {
        super.doStop();
        this.waitForStop(this.processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeallocate() {
        this.processor.deallocate();
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        this.closed = true;
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notify();
        }
        this.stop();
        this.processor.close();
        this.closeSessions();
        super.doClose();
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ReceiveStreamEvent event) {
        RTPManager mgr = (RTPManager)event.getSource();
        if (this.data_sources == null) {
            return;
        }
        RTPManager[] mgrs = this.rtspUtil.getRTPManagers();
        int idx = 0;
        while (idx < mgrs.length) {
            if (mgrs[idx] == mgr) break;
            ++idx;
        }
        if (idx >= mgrs.length) {
            System.err.println("Unknown manager: " + mgr);
            return;
        }
        if (event instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            Log.error("The RTP processor cannot handle mid-stream payload change.\n");
            this.sendEvent(new ControllerErrorEvent(this, "Cannot handle mid-stream payload change."));
            this.close();
        }
        if (event instanceof NewReceiveStreamEvent) {
            if (this.data_sources[idx] != null) {
                return;
            }
            ReceiveStream stream = null;
            try {
                DataSource mixDS;
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                this.data_sources[idx] = stream.getDataSource();
                RTPControl ctl = (RTPControl)this.data_sources[idx].getControl("javax.media.rtp.RTPControl");
                if (ctl != null) {
                    this.formats[idx] = ctl.getFormat();
                    if (this.formats[idx] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.formats[idx] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                int i2 = 0;
                while (i2 < this.data_sources.length) {
                    if (this.data_sources[i2] == null) {
                        return;
                    }
                    ++i2;
                }
                try {
                    mixDS = Manager.createMergingDataSource(this.data_sources);
                }
                catch (Exception e2) {
                    System.err.println("Cannot merge data sources.");
                    return;
                }
                try {
                    this.processor = Manager.createProcessor(mixDS);
                }
                catch (Exception e3) {
                    System.err.println("Cannot create the mix processor.");
                    return;
                }
                if (!this.waitForConfigure(this.processor)) {
                    return;
                }
                Object object = this.dataLock;
                synchronized (object) {
                    this.dataReady = true;
                    this.dataLock.notifyAll();
                }
            }
            catch (Exception e4) {
                System.err.println("NewReceiveStreamEvent exception " + e4.getMessage());
                return;
            }
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        if (!(source instanceof com.sun.media.protocol.rtsp.DataSource)) {
            throw new IncompatibleSourceException();
        }
        MediaLocator ml = source.getLocator();
        this.locators.addElement(ml);
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.processor.getVisualComponent();
    }

    public Control[] getControls() {
        return this.processor.getControls();
    }

    public void updateStats() {
        if (this.processor != null) {
            ((BasicProcessor)this.processor).updateStats();
        }
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        super.getTrackControls();
        return this.processor.getTrackControls();
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        super.getSupportedContentDescriptors();
        return this.processor.getSupportedContentDescriptors();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        super.setContentDescriptor(ocd);
        return this.processor.setContentDescriptor(ocd);
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        super.getContentDescriptor();
        return this.processor.getContentDescriptor();
    }

    public DataSource getDataOutput() throws NotRealizedError {
        super.getDataOutput();
        return this.processor.getDataOutput();
    }

    private boolean waitForConfigure(Processor p) {
        return new StateWaiter().waitForConfigure(p);
    }

    private boolean waitForRealize(Processor p) {
        return new StateWaiter().waitForRealize(p);
    }

    private void waitForStart(Player p) {
        new StateWaiter().waitForStart(p, true);
    }

    private void waitForStop(Player p) {
        new StateWaiter().waitForStart(p, false);
    }

    private void waitForClose(Player p) {
        new StateWaiter().waitForClose(p);
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForConfigure(Processor p) {
            p.addControllerListener(this);
            p.configure();
            Object object = this.stateLock;
            synchronized (object) {
                while (p.getState() != 180 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
            return !this.closeDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForRealize(Processor p) {
            p.addControllerListener(this);
            p.realize();
            Object object = this.stateLock;
            synchronized (object) {
                while (p.getState() != 300 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
            return !this.closeDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(Player p, boolean startOn) {
            p.addControllerListener(this);
            if (startOn) {
                p.start();
            } else {
                p.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((startOn && p.getState() != 600 || !startOn && p.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForClose(Player p) {
            p.addControllerListener(this);
            p.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent || ce instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }
    }
}

