/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jmapps.ui.JMPanel;

public class JMDialog
extends Dialog
implements ActionListener,
WindowListener {
    public static final String ACTION_OK = JMFI18N.getResource("jmstudio.dlg.ok");
    public static final String ACTION_CANCEL = JMFI18N.getResource("jmstudio.dlg.cancel");
    public static final String ACTION_CLOSE = JMFI18N.getResource("jmstudio.dlg.close");
    public static final String ACTION_OPEN = JMFI18N.getResource("jmstudio.dlg.open");
    public static final String ACTION_SAVE = JMFI18N.getResource("jmstudio.dlg.save");
    public static final String ACTION_YES = JMFI18N.getResource("jmstudio.dlg.yes");
    public static final String ACTION_NO = JMFI18N.getResource("jmstudio.dlg.no");
    protected Frame frameOwner = null;
    private String strAction = ACTION_CANCEL;
    private boolean boolFirstTimeVisible = true;

    public JMDialog(Frame frame, String strTitle, boolean boolModal) {
        super(frame, strTitle, boolModal);
        this.frameOwner = frame;
    }

    public void addNotify() {
        this.setBackground(Color.lightGray);
        this.addWindowListener(this);
        super.addNotify();
        this.autoPosition();
    }

    public void setVisible(boolean boolVisible) {
        if (boolVisible && !this.isVisible() && this.boolFirstTimeVisible) {
            this.boolFirstTimeVisible = false;
            this.autoPosition();
        }
        super.setVisible(boolVisible);
    }

    public void autoPosition() {
        if (this.frameOwner != null && this.frameOwner.isShowing()) {
            Point point = this.frameOwner.getLocationOnScreen();
            if (this.isModal()) {
                Insets insets = this.frameOwner.getInsets();
                point.x += insets.left;
                point.y += insets.top;
            } else {
                Dimension dimFrame = this.frameOwner.getSize();
                point.y += dimFrame.height;
            }
            Dimension dim = this.getPreferredSize();
            Dimension dimDialog = this.getSize();
            dimDialog.width = Math.max(dim.width, dimDialog.width);
            dimDialog.height = Math.max(dim.height, dimDialog.height);
            Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + dimDialog.width > dimScreen.width) {
                point.x = dimScreen.width - dimDialog.width;
            }
            if (point.y + dimDialog.height > dimScreen.height) {
                point.y = dimScreen.height - dimDialog.height;
            }
            this.setLocation(point);
        } else {
            this.setLocationCenter();
        }
    }

    public void setLocationCenter() {
        Dimension dimDialog = this.getSize();
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point((dimScreen.width - dimDialog.width) / 2, (dimScreen.height - dimDialog.height) / 2);
        this.setLocation(point);
    }

    public String getAction() {
        return this.strAction;
    }

    protected void setAction(String strAction) {
        this.strAction = strAction;
    }

    protected Frame getOwnerFrame() {
        return this.frameOwner;
    }

    protected JMPanel createButtonPanel(String[] arrActions) {
        JMPanel panelButtons = new JMPanel(new GridLayout(1, 0, 12, 6));
        int nCount = arrActions.length;
        int i2 = 0;
        while (i2 < nCount) {
            Button button = new Button(arrActions[i2]);
            button.addActionListener(this);
            panelButtons.add(button);
            ++i2;
        }
        return panelButtons;
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }
}

