/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class ExternalClient
implements SaslClient {
    private byte[] username;
    private boolean completed = false;

    ExternalClient(String string) throws SaslException {
        if (string != null) {
            try {
                this.username = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("Cannot convert " + string + " into UTF-8", unsupportedEncodingException);
            }
        } else {
            this.username = new byte[0];
        }
    }

    public String getMechanismName() {
        return "EXTERNAL";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("EXTERNAL authentication already completed");
        }
        this.completed = true;
        return this.username;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication Not completed");
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }

    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            return null;
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }
}

