/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.Locale;

final class InputMethodLocator {
    private InputMethodDescriptor descriptor;
    private ClassLoader loader;
    private Locale locale;

    InputMethodLocator(InputMethodDescriptor inputMethodDescriptor, ClassLoader classLoader, Locale locale) {
        if (inputMethodDescriptor == null) {
            throw new NullPointerException("descriptor can't be null");
        }
        this.descriptor = inputMethodDescriptor;
        this.loader = classLoader;
        this.locale = locale;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InputMethodLocator inputMethodLocator = (InputMethodLocator)object;
        if (!this.descriptor.getClass().equals(inputMethodLocator.descriptor.getClass())) {
            return false;
        }
        if (this.loader == null && inputMethodLocator.loader != null || this.loader != null && !this.loader.equals(inputMethodLocator.loader)) {
            return false;
        }
        return (this.locale != null || inputMethodLocator.locale == null) && (this.locale == null || this.locale.equals(inputMethodLocator.locale));
    }

    public int hashCode() {
        int n2 = this.descriptor.hashCode();
        if (this.loader != null) {
            n2 |= this.loader.hashCode() << 10;
        }
        if (this.locale != null) {
            n2 |= this.locale.hashCode() << 20;
        }
        return n2;
    }

    InputMethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    ClassLoader getClassLoader() {
        return this.loader;
    }

    Locale getLocale() {
        return this.locale;
    }

    boolean isLocaleAvailable(Locale locale) {
        try {
            Locale[] localeArray = this.descriptor.getAvailableLocales();
            for (int i2 = 0; i2 < localeArray.length; ++i2) {
                if (!localeArray[i2].equals(locale)) continue;
                return true;
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        return false;
    }

    InputMethodLocator deriveLocator(Locale locale) {
        if (locale == this.locale) {
            return this;
        }
        return new InputMethodLocator(this.descriptor, this.loader, locale);
    }

    boolean sameInputMethod(InputMethodLocator inputMethodLocator) {
        if (inputMethodLocator == this) {
            return true;
        }
        if (inputMethodLocator == null) {
            return false;
        }
        if (!this.descriptor.getClass().equals(inputMethodLocator.descriptor.getClass())) {
            return false;
        }
        return (this.loader != null || inputMethodLocator.loader == null) && (this.loader == null || this.loader.equals(inputMethodLocator.loader));
    }

    String getActionCommandString() {
        String string = this.descriptor.getClass().getName();
        if (this.locale == null) {
            return string;
        }
        return string + "\n" + this.locale.toString();
    }
}

