/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import sun.font.StandardGlyphVector;

public final class AdvanceCache {
    private Font font;
    private FontRenderContext frc;
    private LineMetrics lineMetrics;
    private float[] latinAdvances;
    private float[] kanaAdvances;
    private float cjkAdvance;
    private float cjkFullAdvance;
    private float cjkHalfAdvance;
    private float[] latin1GlyphInfo;
    private float[] kanaGlyphInfo;
    private float[] missingGlyphInfo;
    private float missingGlyphAdvance;
    private static final char KANA_MIN = '\u3040';
    private static final char KANA_LIM = '\u3100';
    private static final char CJK_SAMPLE1 = '\u4e9e';
    private static final char CJK_SAMPLE2 = '\u4e9a';
    private static final char CJK_SAMPLE3 = '\u4e9c';
    private static final char CJK_MIN = '\u3200';
    private static final char CJK_LIM = '\u9fb0';
    private static final char CJKFULL_SAMPLE = '\uff01';
    private static final char CJKFULL1_MIN = '\uff00';
    private static final char CJKFULL1_LIM = '\uff5f';
    private static final char CJKFULL2_MIN = '\uffe0';
    private static final char CJKFULL2_LIM = '\uffe7';
    private static final char CJKHALF_SAMPLE = '\uff61';
    private static final char CJKHALF_MIN = '\uff61';
    private static final char CJKHALF_LIM = '\uff9e';
    private static final char KSYL_SAMPLE = '\uac00';
    private static final char KSYL_MIN = '\uac00';
    private static final char KSYL_MAX = '\ud7a0';
    private static final int CACHE_SIZE = 30;
    private static SoftReference[] cache;
    private static int cacheNum;
    private static boolean enabled;
    private static String latin1;
    private static String kana;
    static int statCount;
    static int statTest;
    static int statMiss;
    static int statFlush;
    static int statFlushDelta;
    static int statLastFlushCount;

    private boolean equals(Font font, FontRenderContext fontRenderContext) {
        return this.font.equals(font) && this.frc.equals(fontRenderContext);
    }

    public static boolean supportsText(char[] cArray, int n2, int n3) {
        if (!enabled) {
            return false;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0100' || c2 >= '\u3040' && c2 < '\u3100' || c2 >= '\u3200' && c2 < '\u9fb0' || c2 >= '\uff61' && c2 < '\uff9e' || c2 >= '\uff00' && c2 < '\uff5f' || c2 >= '\uffe0' && c2 < '\uffe7') continue;
            return false;
        }
        return true;
    }

    public static boolean supportsText(char[] cArray) {
        return AdvanceCache.supportsText(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvanceCache get(Font font, FontRenderContext fontRenderContext) {
        if (!enabled) {
            return null;
        }
        SoftReference[] softReferenceArray = cache;
        synchronized (cache) {
            Object object;
            int n2;
            ++statCount;
            for (n2 = 0; n2 < cacheNum; ++n2) {
                object = (SoftReference[])cache[n2].get();
                if (object == null) {
                    ++statFlush;
                    statFlushDelta = statCount - statLastFlushCount;
                    statLastFlushCount = statCount;
                    cache = new SoftReference[30];
                    cacheNum = 0;
                    break;
                }
                ++statTest;
                if (!super.equals(font, fontRenderContext)) continue;
                if (n2 > 0) {
                    SoftReference softReference = cache[n2];
                    while (n2 > 0) {
                        AdvanceCache.cache[n2--] = cache[n2];
                    }
                    AdvanceCache.cache[0] = softReference;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return object;
            }
            ++statMiss;
            if (n2 == cache.length) {
                object = new SoftReference[cache.length + 30];
                System.arraycopy(cache, 0, object, 1, cache.length);
                cache = object;
            } else {
                while (--n2 >= 0) {
                    AdvanceCache.cache[n2 + 1] = cache[n2];
                }
            }
            object = new AdvanceCache(font, fontRenderContext);
            AdvanceCache.cache[0] = new SoftReference<SoftReference[]>((SoftReference[])object);
            ++cacheNum;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object;
        }
    }

    private void initLatinAdvances() {
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, latin1, this.frc);
        this.latin1GlyphInfo = standardGlyphVector.getGlyphInfo();
        this.latinAdvances = new float[256];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.latinAdvances.length) {
            this.latinAdvances[n2] = this.latin1GlyphInfo[n3 + 2];
            int n4 = n3 + 4;
            this.latin1GlyphInfo[n4] = this.latin1GlyphInfo[n4] - this.latin1GlyphInfo[n3];
            int n5 = n3 + 6;
            this.latin1GlyphInfo[n5] = this.latin1GlyphInfo[n5] + this.latin1GlyphInfo[n3 + 4];
            int n6 = n3 + 7;
            this.latin1GlyphInfo[n6] = this.latin1GlyphInfo[n6] + this.latin1GlyphInfo[n3 + 5];
            ++n2;
            n3 += 8;
        }
        this.latinAdvances[13] = 0.0f;
        this.latinAdvances[10] = 0.0f;
        this.latinAdvances[9] = 0.0f;
    }

    private void initKanaAdvances() {
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, kana, this.frc);
        this.kanaGlyphInfo = standardGlyphVector.getGlyphInfo();
        int n2 = this.font.getMissingGlyphCode();
        this.kanaAdvances = new float[kana.length()];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.kanaAdvances.length) {
            this.kanaAdvances[n3] = this.kanaGlyphInfo[n4 + 2];
            int n5 = n4 + 4;
            this.kanaGlyphInfo[n5] = this.kanaGlyphInfo[n5] - this.kanaGlyphInfo[n4];
            int n6 = n4 + 6;
            this.kanaGlyphInfo[n6] = this.kanaGlyphInfo[n6] + this.kanaGlyphInfo[n4 + 4];
            int n7 = n4 + 7;
            this.kanaGlyphInfo[n7] = this.kanaGlyphInfo[n7] + this.kanaGlyphInfo[n4 + 5];
            ++n3;
            n4 += 8;
        }
        n4 = n3 = 192;
        if (standardGlyphVector.getGlyphCode(n3) == n2) {
            if (standardGlyphVector.getGlyphCode(n3 + 3) != n2) {
                n4 = n3 + 3;
            } else if (standardGlyphVector.getGlyphCode(n3 + 4) != n2) {
                n4 = n3 + 4;
            }
        }
        this.cjkAdvance = this.kanaAdvances[n4];
        if (n4 != n3) {
            System.arraycopy(this.kanaGlyphInfo, n4 * 8, this.kanaGlyphInfo, n3 * 8, 8);
        }
        this.cjkFullAdvance = this.kanaAdvances[n3 + 1];
        this.cjkHalfAdvance = this.kanaAdvances[n3 + 2];
    }

    private void initMissingGlyphInfo() {
        int[] nArray = new int[]{this.font.getMissingGlyphCode()};
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this.font, nArray, this.frc);
        this.missingGlyphInfo = standardGlyphVector.getGlyphInfo();
        this.missingGlyphInfo[4] = this.missingGlyphInfo[4] - this.missingGlyphInfo[0];
        this.missingGlyphInfo[6] = this.missingGlyphInfo[6] + this.missingGlyphInfo[4];
        this.missingGlyphInfo[7] = this.missingGlyphInfo[7] + this.missingGlyphInfo[5];
        this.missingGlyphAdvance = this.missingGlyphInfo[2];
    }

    private AdvanceCache(Font font, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        this.initLatinAdvances();
        this.initKanaAdvances();
        this.initMissingGlyphInfo();
        this.lineMetrics = font.getLineMetrics(latin1, fontRenderContext);
    }

    public LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public float getAdvance(char c2) {
        if (c2 < '\u0100') {
            return this.latinAdvances[c2];
        }
        if (c2 >= '\u3040' && c2 < '\u3100') {
            return this.kanaAdvances[c2 - 12352];
        }
        if (c2 >= '\u3200' && c2 < '\u9fb0') {
            return this.font.canDisplay(c2) ? this.cjkAdvance : this.missingGlyphAdvance;
        }
        if (c2 >= '\uff61' && c2 < '\uff9e') {
            return this.font.canDisplay(c2) ? this.cjkHalfAdvance : this.missingGlyphAdvance;
        }
        if (c2 >= '\uff00' && c2 < '\uff5f') {
            return this.font.canDisplay(c2) ? this.cjkFullAdvance : this.missingGlyphAdvance;
        }
        if (c2 >= '\uffe0' && c2 < '\uffe7') {
            return this.font.canDisplay(c2) ? this.cjkFullAdvance : this.missingGlyphAdvance;
        }
        throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c2));
    }

    public float getAdvance(String string) {
        return this.getAdvance(string.toCharArray());
    }

    public float getAdvance(char[] cArray) {
        return this.getAdvance(cArray, 0, cArray.length);
    }

    public float getAdvance(char[] cArray, int n2, int n3) {
        float f2 = 0.0f;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0100') {
                f2 += this.latinAdvances[c2];
                continue;
            }
            if (c2 >= '\u3040' && c2 < '\u3100') {
                f2 += this.kanaAdvances[c2 - 12352];
                continue;
            }
            if (c2 >= '\u3200' && c2 < '\u9fb0') {
                f2 += this.font.canDisplay(c2) ? this.cjkAdvance : this.missingGlyphAdvance;
                continue;
            }
            if (c2 >= '\uff61' && c2 < '\uff9e') {
                f2 += this.font.canDisplay(c2) ? this.cjkHalfAdvance : this.missingGlyphAdvance;
                continue;
            }
            if (c2 >= '\uff00' && c2 < '\uff5f') {
                f2 += this.font.canDisplay(c2) ? this.cjkFullAdvance : this.missingGlyphAdvance;
                continue;
            }
            if (c2 >= '\uffe0' && c2 < '\uffe7') {
                f2 += this.font.canDisplay(c2) ? this.cjkFullAdvance : this.missingGlyphAdvance;
                continue;
            }
            throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(c2));
        }
        return f2;
    }

    public Rectangle2D getLogicalBounds(String string) {
        return this.getLogicalBounds(string.toCharArray());
    }

    public Rectangle2D getLogicalBounds(char[] cArray) {
        return this.getLogicalBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getLogicalBounds(char[] cArray, int n2, int n3) {
        float f2 = this.getAdvance(cArray, n2, n3);
        return new Rectangle2D.Float(0.0f, -this.lineMetrics.getAscent(), f2, this.lineMetrics.getHeight());
    }

    public Rectangle2D getVisualBounds(String string) {
        return this.getVisualBounds(string.toCharArray());
    }

    public Rectangle2D getVisualBounds(char[] cArray) {
        return this.getVisualBounds(cArray, 0, cArray.length);
    }

    public Rectangle2D getVisualBounds(char[] cArray, int n2, int n3) {
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = Float.MIN_VALUE;
        float f6 = 0.0f;
        float[] fArray = null;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n5 = cArray[i2];
            if (n5 < 256) {
                n4 = n5;
                fArray = this.latin1GlyphInfo;
            } else if (n5 >= 12352 && n5 < 12544) {
                n4 = n5 - 12352;
                fArray = this.kanaGlyphInfo;
            } else if (n5 >= 12800 && n5 < 40880) {
                if (this.font.canDisplay((char)n5)) {
                    n4 = 192;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n4 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65377 && n5 < 65438) {
                if (this.font.canDisplay((char)n5)) {
                    n4 = 193;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n4 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65280 && n5 < 65375) {
                if (this.font.canDisplay((char)n5)) {
                    n4 = 194;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n4 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else if (n5 >= 65504 && n5 < 65511) {
                if (this.font.canDisplay((char)n5)) {
                    n4 = 194;
                    fArray = this.kanaGlyphInfo;
                } else {
                    n4 = 0;
                    fArray = this.missingGlyphInfo;
                }
            } else {
                throw new IndexOutOfBoundsException("no advance for char " + Integer.toHexString(n5));
            }
            float f7 = f6 + fArray[(n4 *= 8) + 4];
            float f8 = fArray[n4 + 5];
            float f9 = f6 + fArray[n4 + 6];
            float f10 = fArray[n4 + 7];
            if (f9 > f7 && f10 > f8) {
                if (f7 < f2) {
                    f2 = f7;
                }
                if (f8 < f3) {
                    f3 = f8;
                }
                if (f9 > f4) {
                    f4 = f9;
                }
                if (f10 > f5) {
                    f5 = f10;
                }
            }
            f6 += fArray[n4 + 2];
        }
        return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(int[] nArray) {
        SoftReference[] softReferenceArray = cache;
        synchronized (cache) {
            nArray[0] = statCount;
            nArray[1] = statTest;
            nArray[2] = statMiss;
            nArray[3] = statFlush;
            nArray[4] = statFlushDelta;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        int n2;
        cache = new SoftReference[30];
        enabled = false;
        char[] cArray = new char[256];
        for (n2 = 0; n2 < cArray.length; ++n2) {
            cArray[n2] = (char)n2;
        }
        cArray[13] = 32;
        cArray[10] = 32;
        cArray[9] = 32;
        latin1 = new String(cArray);
        n2 = 192;
        cArray = new char[n2 + 5];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)(12352 + i2);
        }
        cArray[n2] = 20126;
        cArray[n2 + 1] = 65281;
        cArray[n2 + 2] = 65377;
        cArray[n2 + 3] = 20122;
        cArray[n2 + 4] = 20124;
        kana = new String(cArray);
        try {
            String string = System.getProperty("sun.java2d.font.advancecache");
            if (string != null && string.equals("on")) {
                enabled = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        statCount = 0;
        statTest = 0;
        statMiss = 0;
        statFlush = 0;
        statFlushDelta = 0;
        statLastFlushCount = 0;
    }
}

