/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class Menus {
    public static final char PLUGINS_MENU = 'p';
    public static final char SAVE_AS_MENU = 's';
    public static final char IMPORT_MENU = 'i';
    public static final char SHORTCUTS_MENU = 'h';
    public static final char ABOUT_MENU = 'a';
    public static final char FILTERS_MENU = 'f';
    public static final char TOOLS_MENU = 't';
    public static final char UTILITIES_MENU = 'u';
    public static final int WINDOW_MENU_ITEMS = 5;
    public static final int NORMAL_RETURN = 0;
    public static final int COMMAND_IN_USE = -1;
    public static final int INVALID_SHORTCUT = -2;
    public static final int SHORTCUT_IN_USE = -3;
    public static final int NOT_INSTALLED = -4;
    public static final int COMMAND_NOT_FOUND = -5;
    private static MenuBar mbar;
    private static CheckboxMenuItem gray8Item;
    private static CheckboxMenuItem gray16Item;
    private static CheckboxMenuItem gray32Item;
    private static CheckboxMenuItem color256Item;
    private static CheckboxMenuItem colorRGBItem;
    private static CheckboxMenuItem RGBStackItem;
    private static CheckboxMenuItem HSBStackItem;
    private static PopupMenu popup;
    private static ImageJ ij;
    private static Applet applet;
    private static Hashtable demoImagesTable;
    private static String pluginsPath;
    private static String macrosPath;
    private static Menu pluginsMenu;
    private static Menu importMenu;
    private static Menu saveAsMenu;
    private static Menu shortcutsMenu;
    private static Menu aboutMenu;
    private static Menu filtersMenu;
    private static Menu toolsMenu;
    private static Menu utilitiesMenu;
    private static Menu macrosMenu;
    private static Hashtable pluginsTable;
    static Menu window;
    static int nPlugins;
    private static Hashtable shortcuts;
    private static Vector pluginsPrefs;
    static int windowMenuItems2;
    static String error;
    private static ResourceBundle menubun;
    private static int to_clear;
    static String submenuName;
    static Menu submenu;
    static final int RGB_STACK = 10;
    static final int HSB_STACK = 11;

    Menus(ImageJ ijInstance, Applet appletInstance) {
        ij = ijInstance;
        applet = appletInstance;
        menubun = IJ.getBundle();
    }

    String addMenuBar() {
        error = null;
        pluginsTable = new Hashtable();
        Menu file = new Menu(menubun.getString("File"));
        this.addItem(file, menubun.getString("New"), 78, false);
        this.addItem(file, menubun.getString("Open"), 79, false);
        importMenu = this.addSubMenu(file, "Import", false);
        file.addSeparator();
        this.addItem(file, menubun.getString("Close"), 87, false);
        this.addItem(file, menubun.getString("Save"), 83, false);
        saveAsMenu = this.addSubMenu(file, "SaveAs", false);
        this.addItem(file, menubun.getString("Revert"), 82, false);
        file.addSeparator();
        this.addPlugInItem(file, menubun.getString("PageSetup"), "ij.plugin.filter.Printer(\"setup\")", 0, false);
        this.addPlugInItem(file, menubun.getString("Print"), "ij.plugin.filter.Printer(\"print\")", 80, false);
        file.addSeparator();
        this.addItem(file, menubun.getString("Quit"), 81, false);
        Menu edit = new Menu(menubun.getString("Edit"));
        this.addItem(edit, menubun.getString("Undo"), 90, false);
        edit.addSeparator();
        this.addItem(edit, menubun.getString("Cut"), 88, false);
        this.addItem(edit, menubun.getString("Copy"), 67, false);
        this.addItem(edit, menubun.getString("Paste"), 86, false);
        this.addPlugInItem(edit, menubun.getString("PasteControl"), "ij.plugin.frame.PasteController", 0, false);
        edit.addSeparator();
        this.addPlugInItem(edit, menubun.getString("Clear"), "ij.plugin.filter.Filler(\"clear\")", 0, false);
        this.addPlugInItem(edit, menubun.getString("ClearOutside"), "ij.plugin.filter.Filler(\"outside\")", 0, false);
        this.addPlugInItem(edit, menubun.getString("Fill"), "ij.plugin.filter.Filler(\"fill\")", 70, false);
        this.addPlugInItem(edit, menubun.getString("Draw"), "ij.plugin.filter.Filler(\"draw\")", 68, false);
        this.addPlugInItem(edit, menubun.getString("Invert"), "ij.plugin.filter.Filters(\"invert\")", 73, true);
        edit.addSeparator();
        this.addSubMenu(edit, "Selection", false);
        this.addSubMenu(edit, "Options", false);
        edit.addSeparator();
        this.addItem(edit, menubun.getString("RepeatCommand"), 82, true);
        Menu image = new Menu(menubun.getString("Image"));
        Menu imageType = new Menu(menubun.getString("Type"));
        gray8Item = this.addCheckboxItem(imageType, menubun.getString("8-bit"), "8-bit", "ij.plugin.Converter(\"8-bit\")");
        gray16Item = this.addCheckboxItem(imageType, menubun.getString("16-bit"), "16-bit", "ij.plugin.Converter(\"16-bit\")");
        gray32Item = this.addCheckboxItem(imageType, menubun.getString("32-bit"), "32-bit", "ij.plugin.Converter(\"32-bit\")");
        color256Item = this.addCheckboxItem(imageType, menubun.getString("8-bitColor"), "8-bit Color", "ij.plugin.Converter(\"8-bit Color\")");
        colorRGBItem = this.addCheckboxItem(imageType, menubun.getString("RGBColor"), "RGB Color", "ij.plugin.Converter(\"RGB Color\")");
        imageType.add(new MenuItem("-"));
        RGBStackItem = this.addCheckboxItem(imageType, menubun.getString("RGBStack"), "RGB Stack", "ij.plugin.Converter(\"RGB Stack\")");
        HSBStackItem = this.addCheckboxItem(imageType, menubun.getString("HSBStack"), "HSB Stack", "ij.plugin.Converter(\"HSB Stack\")");
        image.add(imageType);
        image.addSeparator();
        this.addSubMenu(image, "Adjust", false);
        this.addPlugInItem(image, menubun.getString("ShowInfo"), "ij.plugin.filter.Info", 73, false);
        this.addPlugInItem(image, menubun.getString("Properties"), "ij.plugin.filter.ImageProperties", 0, false);
        this.addSubMenu(image, "Color", false);
        this.addSubMenu(image, "Stacks", false);
        image.addSeparator();
        this.addPlugInItem(image, menubun.getString("Crop"), "ij.plugin.filter.Resizer(\"crop\")", 0, false);
        this.addPlugInItem(image, menubun.getString("Duplicate"), "ij.plugin.filter.Duplicater", 68, true);
        this.addPlugInItem(image, menubun.getString("Rename"), "ij.plugin.SimpleCommands(\"rename\")", 0, false);
        this.addPlugInItem(image, menubun.getString("Scale"), "ij.plugin.filter.Scaler", 69, false);
        image.addSeparator();
        this.addSubMenu(image, "Lookup", false);
        this.addPlugInItem(image, menubun.getString("ShowLUT"), "ij.plugin.filter.LutViewer", 0, false);
        this.addPlugInItem(image, menubun.getString("InvertLUT"), "ij.plugin.LutLoader(\"invert\")", 0, false);
        this.addPlugInItem(image, menubun.getString("ColorsWindow"), "ij.plugin.Colors", 0, false);
        Menu math = new Menu(menubun.getString("Operations"));
        this.addPlugInItem(math, menubun.getString("ImageCalculator"), "ij.plugin.ImageCalculator", 0, false);
        math.addSeparator();
        this.addSubMenu(math, "Math", false);
        this.addSubMenu(math, "Rotate", false);
        this.addSubMenu(math, "Translation", false);
        Menu analyze = new Menu(menubun.getString("Analyze"));
        this.addPlugInItem(analyze, menubun.getString("Measure"), "ij.plugin.filter.Analyzer", 77, false);
        this.addPlugInItem(analyze, menubun.getString("ClearResults"), "ij.plugin.filter.Analyzer(\"clear\")", 0, false);
        this.addPlugInItem(analyze, menubun.getString("SetMeasurements"), "ij.plugin.filter.Analyzer(\"set\")", 0, false);
        analyze.addSeparator();
        this.addItem(analyze, menubun.getString("Photometer"), 0, false);
        this.addItem(analyze, menubun.getString("ClearPhotometer"), 0, false);
        this.addItem(analyze, menubun.getString("PhotometrySettings"), 0, false);
        analyze.addSeparator();
        this.addPlugInItem(analyze, menubun.getString("SetScale"), "ij.plugin.filter.ScaleDialog", 0, false);
        this.addItem(analyze, menubun.getString("Histogram"), 72, false);
        this.addPlugInItem(analyze, menubun.getString("PlotProfile"), "ij.plugin.filter.Profiler(\"plot\")", 75, false);
        this.addPlugInItem(analyze, menubun.getString("SurfacePlot"), "ij.plugin.SurfacePlotter", 0, false);
        analyze.addSeparator();
        this.addPlugInItem(analyze, menubun.getString("Radio_Spectrum"), "ij.plugin.RadioSpectrum_Reader", 0, false);
        analyze.addSeparator();
        this.addPlugInItem(analyze, menubun.getString("Optical_Spectrum"), "ij.plugin.TextReader", 0, false);
        analyze.addSeparator();
        toolsMenu = this.addSubMenu(analyze, "Tools", false);
        this.addPlugInItem(analyze, menubun.getString("Calibrate"), "ij.plugin.filter.Calibrator", 0, false);
        window = new Menu(menubun.getString("Window"));
        this.addItem(window, menubun.getString("ImageJ"), 0, false);
        this.addItem(window, menubun.getString("PutBehind"), 0, false);
        this.addPlugInItem(window, menubun.getString("Cascade"), "ij.plugin.WindowOrganizer(\"cascade\")", 0, false);
        this.addPlugInItem(window, menubun.getString("Tile"), "ij.plugin.WindowOrganizer(\"tile\")", 0, false);
        window.addSeparator();
        Menu help = new Menu(menubun.getString("Help"));
        aboutMenu = this.addSubMenu(help, "About", false);
        help.addSeparator();
        this.addPlugInItem(help, menubun.getString("IJWebSite"), "ij.plugin.BrowserLauncher", 0, false);
        this.addPlugInItem(help, menubun.getString("OnlineDocs"), "ij.plugin.BrowserLauncher(\"online\")", 0, false);
        this.addPlugInItem(help, menubun.getString("AboutIJ"), "ij.plugin.AboutBox", 0, false);
        this.addPlugInItem(help, menubun.getString("Credits"), "ij.plugin.BrowserLauncher(\"credits\")", 0, false);
        this.addPluginsMenu();
        if (applet == null) {
            this.installPlugins();
        }
        mbar = new MenuBar();
        mbar.add(file);
        mbar.add(edit);
        mbar.add(image);
        mbar.add(math);
        mbar.add(analyze);
        mbar.add(pluginsMenu);
        mbar.add(window);
        mbar.setHelpMenu(help);
        if (ij != null) {
            ij.setMenuBar(mbar);
        }
        return error;
    }

    void addItem(Menu menu, String label, int shortcut, boolean shift) {
        MenuItem item;
        if (menu == null) {
            return;
        }
        if (shortcut == 0) {
            item = new MenuItem(label);
        } else if (shift) {
            item = new MenuItem(label, new MenuShortcut(shortcut, true));
            shortcuts.put(new Integer(shortcut + 200), label);
        } else {
            item = new MenuItem(label, new MenuShortcut(shortcut));
            shortcuts.put(new Integer(shortcut), label);
        }
        menu.add(item);
        item.addActionListener(ij);
    }

    void addPlugInItem(Menu menu, String label, String className, int shortcut, boolean shift) {
        pluginsTable.put(label, className);
        ++nPlugins;
        this.addItem(menu, label, shortcut, shift);
    }

    CheckboxMenuItem addCheckboxItem(Menu menu, String label, String command, String className) {
        pluginsTable.put(label, className);
        ++nPlugins;
        CheckboxMenuItem item = new CheckboxMenuItem(label);
        item.setActionCommand(command);
        menu.add(item);
        item.addItemListener(ij);
        item.setState(false);
        return item;
    }

    Menu addSubMenu(Menu menu, String name, boolean truename) {
        String value;
        String key = name.toLowerCase(ij.getLocale());
        Menu submenu = truename ? new Menu(name) : new Menu(menubun.getString(name));
        int index = key.indexOf(32);
        if (index > 0) {
            key = key.substring(0, index);
        }
        for (int count = 1; count < 100 && (value = Prefs.getString(key + count / 10 % 10 + count % 10)) != null; ++count) {
            if (count == 1) {
                menu.add(submenu);
            }
            if (value.equals("-")) {
                submenu.addSeparator();
                continue;
            }
            this.addPluginItem(submenu, value);
        }
        return submenu;
    }

    Menu addSubMenu(MenuBar menubar, String name, boolean truename) {
        String value;
        String key = name.toLowerCase(ij.getLocale());
        Menu submenu = truename ? new Menu(name) : new Menu(menubun.getString(name));
        int index = key.indexOf(32);
        if (index > 0) {
            key = key.substring(0, index);
        }
        for (int count = 1; count < 100 && (value = Prefs.getString(key + count / 10 % 10 + count % 10)) != null; ++count) {
            if (count == 1) {
                menubar.add(submenu);
            }
            if (value.equals("-")) {
                submenu.addSeparator();
                continue;
            }
            this.addPluginItem(submenu, value);
        }
        return submenu;
    }

    void addPluginItem(Menu submenu, String s) {
        int openBracket;
        int index = s.lastIndexOf(44);
        if (index <= 0) {
            return;
        }
        String command = s.substring(1, index - 1);
        int keyCode = 0;
        boolean shift = false;
        if (command.endsWith("]") && (openBracket = command.lastIndexOf(91)) > 0) {
            boolean functionKey;
            String shortcut = command.substring(openBracket + 1, command.length() - 1);
            keyCode = Menus.convertShortcutToCode(shortcut);
            boolean bl = functionKey = keyCode >= 112 && keyCode <= 123;
            if (keyCode > 0 && !functionKey) {
                command = command.substring(0, openBracket);
            }
        }
        if (keyCode >= 112 && keyCode <= 123) {
            shortcuts.put(new Integer(keyCode), command);
            keyCode = 0;
        } else if (keyCode > 200) {
            keyCode -= 200;
            shift = true;
        }
        this.addItem(submenu, command, keyCode, shift);
        String className = s.substring(index + 1, s.length());
        pluginsTable.put(command, className);
        ++nPlugins;
    }

    void addPluginsMenu() {
        String value;
        pluginsMenu = new Menu(menubun.getString("Plugins"));
        for (int count = 1; count < 100 && (value = Prefs.getString("plug-in" + count / 10 % 10 + count % 10)) != null; ++count) {
            char firstChar = value.charAt(0);
            if (firstChar == '-') {
                pluginsMenu.addSeparator();
                continue;
            }
            if (firstChar == '>') {
                String submenu = value.substring(2, value.length() - 1);
                Menu menu = this.addSubMenu(pluginsMenu, submenu, false);
                if (("\"" + submenu + "\"").equals(Prefs.getString("plug-in02").substring(1))) {
                    shortcutsMenu = menu;
                    continue;
                }
                if (("\"" + submenu + "\"").equals(Prefs.getString("plug-in03").substring(1))) {
                    utilitiesMenu = menu;
                    continue;
                }
                if (!("\"" + submenu + "\"").equals(Prefs.getString("plug-in01").substring(1))) continue;
                macrosMenu = menu;
                continue;
            }
            this.addPluginItem(pluginsMenu, value);
        }
    }

    void installPlugins() {
        String value;
        String[] plugins = Menus.getPlugins();
        String[] plugins2 = null;
        Hashtable<String, String> skipList = new Hashtable<String, String>();
        for (int index = 0; index < 100 && (value = Prefs.getString("plugin" + index / 10 % 10 + index % 10)) != null; ++index) {
            int argStart;
            Menu menu;
            char menuCode = value.charAt(0);
            switch (menuCode) {
                default: {
                    menu = pluginsMenu;
                    break;
                }
                case 'i': {
                    menu = importMenu;
                    break;
                }
                case 's': {
                    menu = saveAsMenu;
                    break;
                }
                case 'h': {
                    menu = shortcutsMenu;
                    break;
                }
                case 'a': {
                    menu = aboutMenu;
                    break;
                }
                case 'f': {
                    menu = filtersMenu;
                    break;
                }
                case 't': {
                    menu = toolsMenu;
                    break;
                }
                case 'u': {
                    menu = utilitiesMenu;
                }
            }
            String prefsValue = value;
            value = value.substring(2, value.length());
            String className = value.substring(value.lastIndexOf(44) + 1, value.length());
            boolean found = className.startsWith("ij.");
            if (!found && plugins != null) {
                if (plugins2 == null) {
                    plugins2 = this.getStrippedPlugins(plugins);
                }
                for (int i = 0; i < plugins2.length; ++i) {
                    if (!className.startsWith(plugins2[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            this.addPluginItem(menu, value);
            pluginsPrefs.addElement(prefsValue);
            if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
                className = className.substring(0, argStart);
            }
            skipList.put(className, "");
        }
        if (plugins != null) {
            for (int i = 0; i < plugins.length; ++i) {
                if (skipList.containsKey(plugins[i])) continue;
                this.installUserPlugin(plugins[i]);
            }
        }
    }

    String[] getStrippedPlugins(String[] plugins) {
        String[] plugins2 = new String[plugins.length];
        for (int i = 0; i < plugins2.length; ++i) {
            plugins2[i] = plugins[i];
            int slashPos = plugins2[i].lastIndexOf(47);
            if (slashPos < 0) continue;
            plugins2[i] = plugins[i].substring(slashPos + 1, plugins2[i].length());
        }
        return plugins2;
    }

    public static synchronized String[] getPlugins() {
        String homeDir = Prefs.getHomeDir();
        String pluginsDir = Prefs.getPluginsDir();
        if (homeDir == null) {
            return null;
        }
        if (homeDir.endsWith("plugins")) {
            pluginsPath = homeDir;
        } else {
            if (pluginsDir == null) {
                pluginsDir = homeDir;
            } else if (pluginsDir.equals("user.home")) {
                pluginsDir = System.getProperty("user.home");
            }
            pluginsPath = pluginsDir + Prefs.separator + "plugins" + Prefs.separator;
            macrosPath = pluginsDir + Prefs.separator + "macros" + Prefs.separator;
        }
        File f = new File(macrosPath);
        if (macrosPath != null && f != null && !f.isDirectory()) {
            macrosPath = null;
        }
        if ((f = new File(pluginsPath)) != null && !f.isDirectory()) {
            pluginsPath = null;
            return null;
        }
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            boolean isClassFile = name.endsWith(".class");
            if (name.indexOf(95) >= 0 && isClassFile && name.indexOf(36) < 0) {
                name = name.substring(0, name.length() - 6);
                v.addElement(name);
                continue;
            }
            if (isClassFile) continue;
            Menus.checkSubdirectory(pluginsPath, name, v);
        }
        list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    static void checkSubdirectory(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + "/";
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.indexOf(95) < 0 || !name.endsWith(".class") || name.indexOf(36) >= 0) continue;
            name = name.substring(0, name.length() - 6);
            v.addElement(dir + name);
        }
    }

    void installUserPlugin(String className) {
        Menu menu = pluginsMenu;
        int slashIndex = className.indexOf(47);
        if (slashIndex > 0) {
            String dir = className.substring(0, slashIndex);
            className = className.substring(slashIndex + 1, className.length());
            if (submenu == null || !submenuName.equals(dir)) {
                submenuName = dir;
                submenu = new Menu(submenuName);
                pluginsMenu.add(submenu);
            }
            menu = submenu;
        }
        String command = className.replace('_', ' ');
        command.trim();
        MenuItem item = new MenuItem(command);
        menu.add(item);
        item.addActionListener(ij);
        pluginsTable.put(command, className);
        ++nPlugins;
    }

    void installPopupMenu(ImageJ ij) {
        String s;
        int count = 0;
        popup = new PopupMenu("");
        while ((s = Prefs.getString("popup" + ++count / 10 % 10 + count % 10)) != null) {
            if (s.equals("-")) {
                popup.addSeparator();
                continue;
            }
            if (s.equals("")) continue;
            MenuItem mi = new MenuItem(s);
            mi.addActionListener(ij);
            popup.add(mi);
        }
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static Menu getMacrosMenu() {
        return macrosMenu;
    }

    public static void updateMenus() {
        ImageProcessor ip;
        if (ij == null) {
            return;
        }
        gray8Item.setState(false);
        gray16Item.setState(false);
        gray32Item.setState(false);
        color256Item.setState(false);
        colorRGBItem.setState(false);
        RGBStackItem.setState(false);
        HSBStackItem.setState(false);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        int type = imp.getType();
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            if (stack.isRGB()) {
                type = 10;
            } else if (stack.isHSB()) {
                type = 11;
            }
        }
        if (type == 0 && (ip = imp.getProcessor()) != null && ip.isColorLut()) {
            type = 3;
        }
        switch (type) {
            case 0: {
                gray8Item.setState(true);
                break;
            }
            case 1: {
                gray16Item.setState(true);
                break;
            }
            case 2: {
                gray32Item.setState(true);
                break;
            }
            case 3: {
                color256Item.setState(true);
                break;
            }
            case 4: {
                colorRGBItem.setState(true);
                break;
            }
            case 10: {
                RGBStackItem.setState(true);
                break;
            }
            case 11: {
                HSBStackItem.setState(true);
            }
        }
        int nItems = window.getItemCount();
        int start = 5 + windowMenuItems2;
        int index = start + WindowManager.getCurrentIndex();
        boolean active = true;
        for (int i = start; i < nItems; ++i) {
            CheckboxMenuItem item = (CheckboxMenuItem)window.getItem(i);
            try {
                item.setState(i == index);
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    static boolean isColorLut(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        if (cm == null) {
            return false;
        }
        int mapSize = cm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        boolean isColor = false;
        for (int i = 0; i < mapSize; ++i) {
            if (reds[i] == greens[i] && greens[i] == blues[i]) continue;
            isColor = true;
            break;
        }
        return isColor;
    }

    public static String getPlugInsPath() {
        return pluginsPath;
    }

    public static String getMacrosPath() {
        return macrosPath;
    }

    public static Hashtable getCommands() {
        return pluginsTable;
    }

    public static Hashtable getShortcuts() {
        return shortcuts;
    }

    static synchronized void insertWindowMenuItem(Frame win) {
        if (ij == null || win == null) {
            return;
        }
        CheckboxMenuItem item = new CheckboxMenuItem(win.getTitle());
        item.addItemListener(ij);
        int index = 5 + windowMenuItems2;
        if (windowMenuItems2 >= 2) {
            --index;
        }
        window.insert(item, index);
        if (++windowMenuItems2 == 1) {
            window.insertSeparator(5 + windowMenuItems2);
            ++windowMenuItems2;
        }
    }

    static synchronized void addWindowMenuItem(ImagePlus imp) {
        if (ij == null) {
            return;
        }
        String name = imp.getTitle();
        int size = imp.getWidth() * imp.getHeight() * imp.getStackSize() / 1024;
        switch (imp.getType()) {
            case 2: 
            case 4: {
                size *= 4;
                break;
            }
            case 1: {
                size *= 2;
                break;
            }
        }
        CheckboxMenuItem item = new CheckboxMenuItem(name + " " + size + "K");
        window.add(item);
        item.addItemListener(ij);
    }

    static synchronized void removeWindowMenuItem(int index) {
        if (ij == null) {
            return;
        }
        if (index >= 0 && index < window.getItemCount()) {
            window.remove(5 + index);
            if (index < windowMenuItems2 && --windowMenuItems2 == 1) {
                window.remove(5);
                windowMenuItems2 = 0;
            }
        }
    }

    public static synchronized void updateWindowMenuItem(String oldLabel, String newLabel) {
        if (oldLabel.equals(newLabel)) {
            return;
        }
        int first = 5;
        int last = window.getItemCount() - 1;
        for (int i = first; i <= last; ++i) {
            int index;
            MenuItem item = window.getItem(i);
            String label = item.getLabel();
            if (item == null || !label.startsWith(oldLabel)) continue;
            if (label.endsWith("K") && (index = label.lastIndexOf(32)) > -1) {
                newLabel = newLabel + label.substring(index, label.length());
            }
            try {
                item.setLabel(newLabel);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            return;
        }
    }

    public static PopupMenu getPopupMenu() {
        return popup;
    }

    /*
     * WARNING - void declaration
     */
    public static int installPlugin(String plugin, char menuCode, String command, String shortcut, ImageJ ij) {
        void var5_5;
        MenuItem item;
        boolean functionKey;
        if (command.equals("")) {
            return 0;
        }
        if (Menus.commandInUse(command)) {
            return -1;
        }
        if (!Menus.validShortcut(shortcut)) {
            return -2;
        }
        if (Menus.shortcutInUse(shortcut)) {
            return -3;
        }
        switch (menuCode) {
            case 'p': {
                Menu menu = pluginsMenu;
                break;
            }
            case 'i': {
                Menu menu = importMenu;
                break;
            }
            case 's': {
                Menu menu = saveAsMenu;
                break;
            }
            case 'h': {
                Menu menu = shortcutsMenu;
                break;
            }
            case 'a': {
                Menu menu = aboutMenu;
                break;
            }
            case 'f': {
                Menu menu = filtersMenu;
                break;
            }
            case 't': {
                Menu menu = toolsMenu;
                break;
            }
            case 'u': {
                Menu menu = utilitiesMenu;
                break;
            }
            default: {
                return 0;
            }
        }
        int code = Menus.convertShortcutToCode(shortcut);
        boolean bl = functionKey = code >= 112 && code <= 123;
        if (code == 0) {
            item = new MenuItem(command);
        } else if (functionKey) {
            command = command + " [F" + (code - 112 + 1) + "]";
            shortcuts.put(new Integer(code), command);
            item = new MenuItem(command);
        } else {
            shortcuts.put(new Integer(code), command);
            int keyCode = code;
            boolean shift = false;
            if (keyCode > 200) {
                keyCode -= 200;
                shift = true;
            }
            item = new MenuItem(command, new MenuShortcut(keyCode, shift));
        }
        var5_5.add(item);
        item.addActionListener(ij);
        pluginsTable.put(command, plugin);
        shortcut = code > 0 && !functionKey ? "[" + shortcut + "]" : "";
        pluginsPrefs.addElement(menuCode + ",\"" + command + shortcut + "\"," + plugin);
        return 0;
    }

    public static int uninstallPlugin(String command) {
        boolean found = false;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.indexOf(command) <= 0) continue;
            pluginsPrefs.removeElement(cmd);
            found = true;
            break;
        }
        if (found) {
            return 0;
        }
        return -5;
    }

    public static boolean commandInUse(String command) {
        return pluginsTable.get(command) != null;
    }

    public static int convertShortcutToCode(String shortcut) {
        int code = 0;
        int len = shortcut.length();
        if (len == 2 && shortcut.startsWith("F")) {
            code = 112 + shortcut.charAt(1) - 49;
            if (code >= 112 && code <= 120) {
                return code;
            }
            return 0;
        }
        if (len == 3 && shortcut.startsWith("F")) {
            code = 121 + shortcut.charAt(2) - 48;
            if (code >= 121 && code <= 123) {
                return code;
            }
            return 0;
        }
        if (len != 1) {
            return 0;
        }
        char c = shortcut.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            code = 65 + c - 65 + 200;
        } else if (c >= 'a' && c <= 'z') {
            code = 65 + c - 97;
        } else if (c >= '0' && c <= '9') {
            code = 48 + c - 48;
        }
        return code;
    }

    int installMacros() {
        if (macrosPath == null) {
            return 0;
        }
        String path = macrosPath + "StartupMacros.txt";
        File f = new File(path);
        if (f == null || !f.exists()) {
            return 0;
        }
        MacroInstaller mi = new MacroInstaller();
        mi.run(path);
        return mi.getMacroCount();
    }

    static boolean validShortcut(String shortcut) {
        int len = shortcut.length();
        if (shortcut.equals("")) {
            return true;
        }
        if (len == 1) {
            return true;
        }
        return shortcut.startsWith("F") && (len == 2 || len == 3);
    }

    public static boolean shortcutInUse(String shortcut) {
        int code = Menus.convertShortcutToCode(shortcut);
        return shortcuts.get(new Integer(code)) != null;
    }

    public static void savePreferences(Properties prefs) {
        int index = 0;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String key = "plugin" + index / 10 % 10 + index % 10;
            prefs.put(key, (String)en.nextElement());
            ++index;
        }
    }

    static {
        demoImagesTable = new Hashtable();
        shortcuts = new Hashtable();
        pluginsPrefs = new Vector();
    }
}

