/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.CurveFitter;

public class Calibration {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int NONE = 20;
    public static final int UNCALIBRATED_OD = 21;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public double frameInterval;
    public double xOrigin;
    public double yOrigin;
    public double zOrigin;
    public String info;
    private double[] coefficients;
    private String unit = IJ.getBundle().getString("Pixels");
    private String units;
    private String valueUnit = IJ.getBundle().getString("CalGrayVal");
    private int function = 20;
    private float[] cTable;
    private boolean invertedLut;
    private int bitDepth = 8;
    private boolean zeroClip;

    public Calibration(ImagePlus imp) {
        this();
        if (imp != null) {
            this.bitDepth = imp.getBitDepth();
            this.invertedLut = imp.isInvertedLut();
        }
    }

    public Calibration() {
    }

    public boolean scaled() {
        return this.pixelWidth != 1.0 || this.pixelHeight != 1.0;
    }

    public void setUnit(String unit) {
        this.unit = unit == null || unit.equals("") ? "pixel" : unit;
        this.units = null;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnits() {
        if (this.units == null) {
            this.units = this.unit.equals("pixel") ? "pixels" : (this.unit.equals("micron") ? "microns" : (this.unit.equals("inch") ? "inches" : this.unit));
        }
        return this.units;
    }

    public double getX(int x) {
        return ((double)x - this.xOrigin) * this.pixelWidth;
    }

    public double getY(int y) {
        int height = IJ.getImage().getHeight();
        return ((double)(height - 1) - ((double)y - this.yOrigin)) * this.pixelHeight;
    }

    public double getZ(int z) {
        return ((double)z - this.zOrigin) * this.pixelDepth;
    }

    public void setFunction(int function, double[] coefficients, String unit) {
        this.setFunction(function, coefficients, unit, false);
    }

    public void setFunction(int function, double[] coefficients, String unit, boolean zeroClip) {
        if (function == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (coefficients == null && function >= 0 && function <= 8) {
            return;
        }
        this.function = function;
        this.coefficients = coefficients;
        this.zeroClip = zeroClip;
        if (unit != null) {
            this.valueUnit = unit;
        }
        this.cTable = null;
    }

    public void setImage(ImagePlus imp) {
        if (imp == null) {
            return;
        }
        int type = imp.getType();
        int newBitDepth = imp.getBitDepth();
        if (newBitDepth != this.bitDepth || type == 2 || type == 4) {
            this.disableDensityCalibration();
        }
        this.bitDepth = newBitDepth;
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.cTable = null;
        this.valueUnit = IJ.getBundle().getString("CalGrayVal");
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public boolean calibrated() {
        return this.function != 20;
    }

    public int getFunction() {
        return this.function;
    }

    public float[] getCTable() {
        if (this.cTable == null) {
            this.makeCTable();
        }
        return this.cTable;
    }

    void makeCTable() {
        if (this.bitDepth == 16) {
            this.make16BitCTable();
            return;
        }
        if (this.bitDepth != 8) {
            return;
        }
        if (this.function == 21) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                this.cTable[i] = (float)this.od(i);
            }
        } else if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[256];
            for (int i = 0; i < 256; ++i) {
                double value = CurveFitter.f(this.function, this.coefficients, i);
                this.cTable[i] = this.zeroClip && value < 0.0 ? 0.0f : (float)value;
            }
        } else {
            this.cTable = null;
        }
    }

    void make16BitCTable() {
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[65536];
            for (int i = 0; i < 65536; ++i) {
                this.cTable[i] = (float)CurveFitter.f(this.function, this.coefficients, i);
            }
        } else {
            this.cTable = null;
        }
    }

    double od(double v) {
        if (this.invertedLut) {
            if (v == 255.0) {
                v = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - v));
        }
        if (v == 0.0) {
            v = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / v);
    }

    public double getCValue(int value) {
        if (this.function == 20) {
            return value;
        }
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            double v = CurveFitter.f(this.function, this.coefficients, value);
            if (this.zeroClip && v < 0.0) {
                return 0.0;
            }
            return v;
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        if (this.cTable != null && value >= 0 && value < this.cTable.length) {
            return this.cTable[value];
        }
        return value;
    }

    public double getCValue(double value) {
        if (this.function == 20) {
            return value;
        }
        return this.getCValue((int)value);
    }

    public double getRawValue(double value) {
        if (this.function == 20) {
            return value;
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        float fvalue = (float)value;
        float smallestDiff = Float.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this.cTable.length; ++i) {
            float diff = fvalue - this.cTable[i];
            if (diff < 0.0f) {
                diff = -diff;
            }
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            index = i;
        }
        return index;
    }

    public Calibration copy() {
        Calibration copy = new Calibration();
        copy.pixelWidth = this.pixelWidth;
        copy.pixelHeight = this.pixelHeight;
        copy.pixelDepth = this.pixelDepth;
        copy.frameInterval = this.frameInterval;
        copy.xOrigin = this.xOrigin;
        copy.yOrigin = this.yOrigin;
        copy.zOrigin = this.zOrigin;
        copy.info = this.info;
        copy.unit = this.unit;
        copy.units = this.units;
        copy.valueUnit = this.valueUnit;
        copy.function = this.function;
        copy.coefficients = this.coefficients;
        copy.cTable = this.cTable;
        copy.invertedLut = this.invertedLut;
        copy.bitDepth = this.bitDepth;
        copy.zeroClip = this.zeroClip;
        return copy;
    }

    public boolean equals(Calibration cal) {
        if (cal == null) {
            return false;
        }
        boolean equal = true;
        if (cal.pixelWidth != this.pixelWidth || cal.pixelHeight != this.pixelHeight || cal.pixelDepth != this.pixelDepth) {
            equal = false;
        }
        if (!cal.unit.equals(this.unit)) {
            equal = false;
        }
        if (!cal.valueUnit.equals(this.valueUnit) || cal.function != this.function) {
            equal = false;
        }
        return equal;
    }

    public String toString() {
        return "w=" + this.pixelWidth + ", h=" + this.pixelHeight + ", d=" + this.pixelDepth + ", unit=" + this.unit + ", f=" + this.function + ", nc=" + (this.coefficients != null ? "" + this.coefficients.length : "null") + ", table=" + (this.cTable != null ? "" + this.cTable.length : "null") + ", vunit=" + this.valueUnit;
    }
}

