/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.PlotWindow;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class RadioSpectrum_Reader
extends ImagePlus
implements PlugIn {
    private String directory;
    private String fileName;
    public static int SCALETYPE;
    private final int pixel = 0;
    private final int velocity = 1;
    private final int frequency = 2;
    private final int wavelength = 3;
    private static double xGaussCenter;
    private static double yGaussCenter;
    private static double widthGauss;
    private static double area;
    private static double l;
    private static double b;
    private static String xLabel;
    private static String yLabel;
    private static Hashtable results;
    private static TextWindow res;
    private static int rdindex;
    private static ResourceBundle bun;

    public void run(String arg) {
        OpenDialog od = new OpenDialog(IJ.getBundle().getString("Open"), arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + fileName);
        FitsDecoder fd = new FitsDecoder(directory, fileName);
        FileInfo fi = null;
        try {
            fi = fd.getInfo();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (fi != null && fi.width > 0 && fi.height == 1 && fi.offset > 0 && fi.nImages == 1) {
            int i;
            int length;
            fi.fileType = 2;
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            ImageProcessor ip = imp.getProcessor();
            ip.flipVertical();
            Calibration cal = imp.getCalibration();
            double bzero = fd.getBzero();
            double bscale = fd.getBscale();
            imp.setProperty("Info", fd.getHeaderInfo());
            imp.setFileInfo(fi);
            short[] shortpixels = null;
            float[] floatpixels = null;
            if (fi.fileType == 1 || fi.fileType == 2) {
                shortpixels = (short[])ip.getPixels();
                length = shortpixels.length;
            } else {
                floatpixels = (float[])ip.getPixels();
                length = floatpixels.length;
            }
            xLabel = IJ.getPluginBundle().getString("ChannelRS");
            switch (SCALETYPE) {
                case 1: {
                    xLabel = bun.getString("VelocityRS") + " (" + bun.getString("unitsVelocityRS") + ")";
                    break;
                }
                case 2: {
                    xLabel = bun.getString("FrequencyRS") + " (" + bun.getString("unitsFrequencyRS") + ")";
                    break;
                }
                case 3: {
                    xLabel = bun.getString("WavelengthRS") + " (" + bun.getString("unitsWavelengthRS") + ")";
                    break;
                }
                default: {
                    xLabel = bun.getString("ChannelRS");
                }
            }
            yLabel = bun.getString("IntensityRS");
            l = fd.getCrval2();
            b = fd.getCrval3();
            float[] xValues = new float[length];
            IJ.showProgress(0.0);
            double restfreq = fd.getRestfreq();
            if (restfreq == 0.0) {
                restfreq = fd.getCrval1();
            }
            double deltav = fd.getDeltav() == 0.0 & SCALETYPE == 1 ? -3.0E8 * fd.getCdelt1() / restfreq : fd.getDeltav();
            block13: for (int i2 = 0; i2 < length; ++i2) {
                switch (SCALETYPE) {
                    case 0: {
                        xValues[i2] = i2;
                        continue block13;
                    }
                    case 1: {
                        xValues[length - 1 - i2] = (float)(((double)(i2 + 1 - length / 2) * deltav + fd.getVelolsr()) * 0.001);
                        continue block13;
                    }
                    case 2: {
                        xValues[i2] = (float)((restfreq + fd.getCdelt1() * ((double)i2 - fd.getCrpix1())) * 1.0E-6);
                        continue block13;
                    }
                    case 3: {
                        xValues[i2] = (float)(3.0E10 / (restfreq + fd.getCdelt1() * (fd.getCrpix1() - (double)i2)));
                        continue block13;
                    }
                    default: {
                        xValues[i2] = i2;
                    }
                }
            }
            float[] yValues = new float[length];
            double[] coeff = cal.getCoefficients();
            if (coeff == null) {
                coeff = new double[]{0.0, 1.0};
            }
            bzero = bscale * coeff[0] + bzero;
            bscale = coeff[1] * bscale;
            if (fi.fileType == 1 || fi.fileType == 2) {
                for (i = 0; i < length; ++i) {
                    yValues[i] = (float)(bscale * (double)shortpixels[i] + bzero);
                }
            } else {
                for (i = 0; i < length; ++i) {
                    yValues[i] = (float)(bscale * (double)floatpixels[i] + bzero);
                }
            }
            PlotWindow.RadioSpectra = true;
            PlotWindow.Base_Line_subtracted = false;
            PlotWindow.Base_Line = false;
            PlotWindow.ZERO_LINE = false;
            PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fileName, xLabel, yLabel, xValues, yValues, imp);
            pw.draw();
        } else {
            IJ.error(bun.getString("error0"));
        }
        IJ.showStatus("");
    }

    public static int gaussianFitSpectralLine(float[] xvals, float[] yvals, double[] a) {
        int ma;
        int DIM = 3;
        int dof = xvals.length;
        double amplitude = a[0];
        double center = a[1];
        double width = a[2];
        double[] chisq = new double[1];
        double[] ochisq = new double[1];
        double[] aa = Tools.getMinMax(yvals);
        double yvalsMax = aa[1];
        if (amplitude == 0.0) {
            amplitude = yvalsMax;
        }
        if (center == 0.0) {
            for (int i = 0; i < xvals.length; ++i) {
                if ((double)yvals[i] != yvalsMax) continue;
                center = xvals[i];
            }
        }
        if (width == 0.0) {
            width = 10.0;
        }
        if (dof <= (ma = DIM)) {
            IJ.error(bun.getString("error1"));
            return 0;
        }
        double[][] covar = new double[ma][ma];
        double[][] alpha = new double[ma][ma];
        double[] sig = new double[xvals.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = 1.0;
        }
        a[0] = amplitude;
        a[1] = center;
        a[2] = width;
        int[] ia = new int[3];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = 1;
        }
        double[] alamda = new double[]{-1.0};
        int err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
        int iter = 0;
        int itst = 0;
        while (itst < 5 && err != 0) {
            ++iter;
            ochisq[0] = chisq[0];
            err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
            if (chisq[0] > ochisq[0]) {
                itst = 0;
                continue;
            }
            if (!(Math.abs(ochisq[0] - chisq[0]) < 0.001)) continue;
            ++itst;
        }
        alamda[0] = 0.0;
        if (err != 0) {
            err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
        }
        amplitude = a[0];
        center = a[1];
        width = a[2];
        return err;
    }

    public static void activate() {
        if (res == null) {
            StringBuffer sb;
            results = new Hashtable();
            if (results.size() > 0) {
                Enumeration keys = results.keys();
                sb = new StringBuffer();
                int i = 1;
                int m = 0;
                while (keys.hasMoreElements()) {
                    ++i;
                    int n = Integer.parseInt((String)keys.nextElement());
                    if (n <= m) continue;
                    m = n;
                }
                for (int j = 1; j <= m; ++j) {
                    IRad res = (IRad)results.get(String.valueOf(j));
                    if (res == null) continue;
                    sb.append(j + "\t" + res.toString() + "\n");
                }
            } else {
                sb = null;
            }
            res = new TextWindow(bun.getString("GaussFitResults"), bun.getString("measurements") + "\t" + bun.getString("File") + "\tl\tb\t" + xLabel + "\t" + yLabel + "\t" + bun.getString("Width") + "\t" + bun.getString("Area"), sb == null ? null : new String(sb), 536, 200);
            res.setLocation(5, 475);
        }
        if (!res.isShowing()) {
            rdindex = 1;
            res.getTextPanel().setColumnHeadings(bun.getString("measurements") + "\t" + bun.getString("File") + "\tl\tb\t" + xLabel + "\t" + yLabel + "\t" + bun.getString("Width") + "\t" + bun.getString("Area"));
            res.setVisible(true);
        }
        WindowManager.activateWindow(bun.getString("GaussFitResults"));
    }

    public static void clear() {
        if (results == null) {
            return;
        }
        results.clear();
        rdindex = 1;
        if (res != null) {
            res.getTextPanel().selectAll();
            res.getTextPanel().clearSelection();
        }
    }

    public static void clear(String s) {
        StringTokenizer st1 = new StringTokenizer(s, "\n");
        while (st1.hasMoreTokens()) {
            String s1 = st1.nextToken();
            StringTokenizer st = new StringTokenizer(s1, "\t");
            try {
                int index = Integer.parseInt(st.nextToken());
                String img = st.nextToken();
                results.remove(String.valueOf(index));
            }
            catch (Exception e) {}
        }
    }

    public void close() {
        if (res != null) {
            res.close();
            res = null;
        }
    }

    public static void addResult(ImagePlus imp, double[] a) {
        RadioSpectrum_Reader.activate();
        FileInfo fi = imp.getOriginalFileInfo();
        String t = fi.fileName;
        area = 1.064467 * a[0] * a[2];
        widthGauss = a[2];
        xGaussCenter = a[1];
        yGaussCenter = a[0];
        res.append(new String(rdindex + "\t" + t + "\t" + IJ.d2s(l) + "\t" + IJ.d2s(b) + "\t" + IJ.d2s(xGaussCenter) + "\t" + IJ.d2s(yGaussCenter) + "\t" + IJ.d2s(widthGauss) + "\t" + IJ.d2s(area)));
        res.getTextPanel().resetSelection();
        results.put(String.valueOf(rdindex), new IRad(t, xGaussCenter, yGaussCenter, widthGauss, area, l, b));
        ++rdindex;
    }

    static {
        rdindex = 1;
        bun = IJ.getPluginBundle();
    }

    static class IRad {
        String title;
        double xx;
        double yy;
        double ww;
        double aa;
        double ll;
        double bb;

        public IRad(String i, double xx, double yy, double ww, double aa, double ll, double bb) {
            this.title = new String(i);
            this.xx = xx;
            this.yy = yy;
            this.ww = ww;
            this.aa = aa;
            this.ll = ll;
            this.bb = bb;
        }

        public String toString() {
            return new String(this.title + "\t" + IJ.d2s(this.ll) + "\t" + IJ.d2s(this.bb) + "\t" + IJ.d2s(this.xx) + "\t" + IJ.d2s(this.yy) + "\t" + IJ.d2s(this.ww) + "\t" + IJ.d2s(this.aa));
        }
    }
}

