/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class SimpleCommands
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("unlock")) {
            this.unlock(imp);
        } else if (arg.equals("rename")) {
            this.rename(imp);
        }
    }

    void unlock(ImagePlus imp) {
        boolean wasUnlocked = imp.lockSilently();
        if (wasUnlocked) {
            IJ.showStatus("\"" + imp.getTitle() + "\" " + IJ.getPluginBundle().getString("NotLocked"));
        } else {
            IJ.showStatus("\"" + imp.getTitle() + "\" " + IJ.getPluginBundle().getString("Unlocked"));
            IJ.beep();
        }
        imp.unlock();
    }

    void rename(ImagePlus imp) {
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("Rename"));
        gd.addStringField(IJ.getPluginBundle().getString("RenameName"), imp.getTitle(), 30);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        imp.setTitle(gd.getNextString());
    }
}

