/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ColorTable;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.TrimmedLabel;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabelsKeys = new String[]{"RedColor", "GreenColor", "BlueColor", "CyanColor", "MagentaColor", "YellowColor", "ColorRGB"};
    static String[] channelLabels;
    static final int[] channelConstants;
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int minSliderValue = -1;
    int maxSliderValue = -1;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    Object previousSnapshot;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label windowLabel;
    Label levelLabel;
    boolean done;
    int autoThreshold;
    GridBagLayout gridbag;
    GridBagConstraints c;
    int y = 0;
    boolean windowLevel;
    boolean balance;
    Font monoFont = new Font("Monospaced", 0, 12);
    Font sanFont = new Font("SansSerif", 0, 12);
    int channels = 7;
    Choice choice;
    static ResourceBundle bun;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 64;
    ColorTable colorpanel = new ColorTable();
    static int deb;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;

    public ContrastAdjuster() {
        super(bun.getString("ContrastTitle"));
        if (channelLabels == null) {
            channelLabels = new String[channelLabelsKeys.length];
            for (int i = 0; i < channelLabels.length; ++i) {
                ContrastAdjuster.channelLabels[i] = IJ.getColorBundle().getString(channelLabelsKeys[i]);
            }
        }
    }

    public void run(String arg) {
        this.windowLevel = arg.equals("wl");
        this.balance = arg.equals("balance");
        if (this.windowLevel) {
            this.setTitle(bun.getString("WLTitle"));
        } else if (this.balance) {
            this.setTitle(bun.getString("ColorTitle"));
            this.channels = 4;
        }
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        IJ.register(ContrastAdjuster.class);
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.y = 0;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.c.gridy = this.y++;
        this.gridbag.setConstraints(this.colorpanel, this.c);
        this.add(this.colorpanel);
        this.c.gridy = this.y++;
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        if (!this.windowLevel) {
            this.panel = new Panel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 10, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label("          ", 0);
            this.minLabel.setFont(this.monoFont);
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label("          ", 2);
            this.maxLabel.setFont(this.monoFont);
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 16, 0, this.sliderRange);
            this.addLabel(bun.getString("Minimum"), null);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 30, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.setUnitIncrement(1);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 16, 0, this.sliderRange);
            this.addLabel(bun.getString("Maximum"), null);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 30, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.setUnitIncrement(1);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 16, 0, this.sliderRange);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel(bun.getString("Level"), this.levelLabel);
        } else {
            this.addLabel(bun.getString("Brightness"), null);
        }
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 30, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 16, 0, this.sliderRange);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel(bun.getString("Window"), this.windowLabel);
            } else {
                this.addLabel(bun.getString("Contrast"), null);
            }
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 30, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.setUnitIncrement(1);
        }
        if (this.balance) {
            this.c.gridy = this.y++;
            this.c.insets = new Insets(5, 10, 30, 10);
            this.choice = new Choice();
            for (int i = 0; i < channelLabels.length; ++i) {
                this.choice.addItem(channelLabels[i]);
            }
            this.gridbag.setConstraints(this.choice, this.c);
            this.choice.addItemListener(this);
            this.add(this.choice);
        }
        int trim = IJ.isMacOSX() ? 20 : 0;
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.autoB = new TrimmedButton(bun.getString("Auto"), trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton(bun.getString("Reset"), trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton(bun.getString("Set"), trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new TrimmedButton(bun.getString("Apply"), trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(8, 5, 10, 5);
        this.gridbag.setConstraints(this.panel, this.c);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.show();
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
        this.setResizable(false);
    }

    void addLabel(String text, Label label2) {
        this.panel = new Panel();
        this.c.gridy = this.y++;
        this.c.insets = new Insets(0, 10, 0, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label2 == null ? 1 : 0, 0, 0));
        TrimmedLabel label = new TrimmedLabel(text);
        label.setFont(this.sanFont);
        this.panel.add(label);
        if (label2 != null) {
            label2.setFont(this.monoFont);
            label2.setAlignment(0);
            this.panel.add(label2);
        }
        this.add(this.panel);
    }

    void setup() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageProcessor ip = imp.getProcessor();
            this.setup(imp);
            this.updateLabels(imp, ip);
            this.colorpanel.lut = imp.createLut();
            this.updatePlot();
            imp.updateAndDraw();
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (e.getSource() == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (e.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.setB) {
            this.doSet = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.threshB) {
            this.colorpanel.magdisp = !this.colorpanel.magdisp;
            this.updatePlot();
        } else if (b == this.updateB) {
            this.doUpdate = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean snapshotChanged;
        ImageProcessor ip = imp.getProcessor();
        int type = imp.getType();
        this.RGBImage = type == 4;
        boolean bl = snapshotChanged = this.RGBImage && this.previousSnapshot != null && ((ColorProcessor)ip).getSnapshotPixels() != this.previousSnapshot;
        if (imp.getID() != this.previousImageID || snapshotChanged || type != this.previousType) {
            this.setupNewImage(imp, ip);
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        return ip;
    }

    void setupNewImage(ImagePlus imp, ImageProcessor ip) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            ip.snapshot();
            this.previousSnapshot = ((ColorProcessor)ip).getSnapshotPixels();
        } else {
            this.previousSnapshot = null;
        }
        double min2 = ip.getMin();
        double max2 = ip.getMax();
        if (imp.getType() == 4) {
            min2 = 0.0;
            max2 = 255.0;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(ip, min2, max2);
        this.min = ip.getMin();
        this.max = ip.getMax();
        if (IJ.debugMode) {
            IJ.log("min: " + this.min);
            IJ.log("max: " + this.max);
            IJ.log("defaultMin: " + this.defaultMin);
            IJ.log("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        this.updateScrollBars(null);
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
        this.autoThreshold = 0;
    }

    void setMinAndMax(ImageProcessor ip, double min, double max) {
        if (this.channels != 7 && ip instanceof ColorProcessor) {
            ((ColorProcessor)ip).setMinAndMax(min, max, this.channels);
        } else {
            ip.setMinAndMax(min, max);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
        this.colorpanel.newmin = (long)this.min;
        this.colorpanel.newmax = (long)this.max;
        this.colorpanel.orgmin = (long)this.defaultMin;
        this.colorpanel.orgmax = (long)this.defaultMax;
        switch (WindowManager.getCurrentImage().getType()) {
            case 1: {
                this.colorpanel.factor = 256L;
                break;
            }
            case 2: {
                this.colorpanel.factor = 65536L;
                break;
            }
            default: {
                this.colorpanel.factor = 1L;
            }
        }
        this.colorpanel.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        int digits;
        boolean realValue;
        double min = ip.getMin();
        double max = ip.getMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            if (type != 1) {
                realValue = true;
            }
        }
        int n = digits = realValue ? 2 : 0;
        if (this.windowLevel) {
            double window = max - min;
            double level = min + window / 2.0;
            this.windowLabel.setText(IJ.d2s(window, digits));
            this.levelLabel.setText(IJ.d2s(level, digits));
        } else {
            this.minLabel.setText(IJ.d2s(min, digits));
            this.maxLabel.setText(IJ.d2s(max, digits));
        }
    }

    void updateScrollBars(Scrollbar sb) {
        if (sb == null || sb != this.contrastSlider) {
            double mid = this.sliderRange / 2;
            double c = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
            if (c > mid) {
                c = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
            }
            this.contrast = (int)c;
            if (this.contrastSlider != null) {
                this.contrastSlider.setValue(this.contrast);
            }
        }
        if (sb == null || sb != this.brightnessSlider) {
            double level = this.min + (this.max - this.min) / 2.0;
            double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
            this.brightnessSlider.setValue(this.brightness);
        }
        if (this.minSlider != null && (sb == null || sb != this.minSlider)) {
            this.minSlider.setValue(this.scaleDown(this.min));
        }
        if (this.maxSlider != null && (sb == null || sb != this.maxSlider)) {
            this.maxSlider.setValue(this.scaleDown(this.max));
        }
    }

    int scaleDown(double v) {
        if (v < this.defaultMin) {
            v = this.defaultMin;
        }
        if (v > this.defaultMax) {
            v = this.defaultMax;
        }
        return (int)((v - this.defaultMin) * 255.0 / (this.defaultMax - this.defaultMin));
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        int[] mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMin(ImagePlus imp, ImageProcessor ip, double minvalue) {
        this.min = this.defaultMin + minvalue * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.minSlider);
    }

    void adjustMax(ImagePlus imp, ImageProcessor ip, double maxvalue) {
        this.max = this.defaultMin + maxvalue * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.min < 0.0) {
            this.min = 0.0;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.maxSlider);
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.brightnessSlider);
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        this.setMinAndMax(ip, this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.contrastSlider);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(ip, this.min, this.max);
        this.updateScrollBars(null);
        this.plotHistogram(imp);
        this.autoThreshold = 0;
        if (Recorder.record) {
            Recorder.record("resetMinAndMax");
        }
    }

    void update(ImagePlus imp, ImageProcessor ip) {
        if (this.previousMin == 0.0 && this.previousMax == 0.0 || imp.getType() != this.previousType) {
            IJ.beep();
        } else {
            this.min = this.previousMin;
            this.max = this.previousMax;
            this.setMinAndMax(ip, this.min, this.max);
            this.updateScrollBars(null);
            this.plotHistogram(imp);
        }
    }

    void plotHistogram(ImagePlus imp) {
        ImageStatistics stats;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imp.getType() == 4) {
            int w = imp.getWidth();
            int h = imp.getHeight();
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ((ColorProcessor)imp.getProcessor()).getRGB(r, g, b);
            byte[] pixels = null;
            if (this.channels == 4) {
                pixels = r;
            } else if (this.channels == 2) {
                pixels = g;
            } else if (this.channels == 1) {
                pixels = b;
            }
            ByteProcessor ip = new ByteProcessor(w, h, pixels, null);
            stats = ImageStatistics.getStatistics(ip, 0, imp.getCalibration());
        } else {
            stats = imp.getStatistics();
        }
        this.plot.setHistogram(stats);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            imp.unlock();
        }
        if (!imp.lock()) {
            return;
        }
        if (imp.getType() == 4) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                ip.snapshot();
                this.reset(imp, ip);
                imp.changes = true;
            }
            imp.unlock();
            return;
        }
        if (imp.getType() != 0) {
            IJ.beep();
            IJ.showStatus(bun.getString("AdjTypeErr"));
            imp.unlock();
            return;
        }
        int[] table = new int[256];
        int min = (int)ip.getMin();
        int max = (int)ip.getMax();
        for (int i = 0; i < 256; ++i) {
            table[i] = i <= min ? 0 : (i >= max ? 255 : (int)((double)(i - min) / (double)(max - min) * 255.0));
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, IJ.getBundle().getString("ProcStackTitle"), bun.getString("LUT1") + " " + stack.getSize() + " " + bun.getString("LUT2"));
            if (d.cancelPressed()) {
                imp.unlock();
                return;
            }
            if (d.yesPressed()) {
                new StackProcessor(stack, ip).applyTable(table);
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
        this.reset(imp, ip);
        imp.changes = true;
        imp.unlock();
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel(IJ.getBundle().getString("ProcStackTitle"), bun.getString("RGB1") + n + "\n" + bun.getString("RGB2") + "\n" + IJ.getBundle().getString("NoUndoConfirm"))) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            if (i == current) continue;
            imp.setSlice(i);
            ImageProcessor ip = imp.getProcessor();
            this.setMinAndMax(ip, this.min, this.max);
            IJ.showProgress((double)i / (double)n);
        }
        imp.setSlice(current);
        imp.changes = true;
    }

    void threshold(ImagePlus imp, ImageProcessor ip) {
        int threshold = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = threshold;
        this.max = threshold;
        this.setMinAndMax(ip, this.min, this.max);
        this.setThreshold(ip);
        this.updateScrollBars(null);
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        int[] mask;
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i] > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = found = histogram[--i] > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax >= hmin) {
            imp.killRoi();
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        this.setMinAndMax(ip, this.min, this.max);
        this.updateScrollBars(null);
        Roi roi = imp.getRoi();
        if (roi != null && (mask = roi.getMask()) != null) {
            ip.reset(mask);
        }
    }

    void setMinAndMax(ImagePlus imp, ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        GenericDialog gd = new GenericDialog(bun.getString("SetMinMaxTitle"));
        gd.addNumericField(bun.getString("MinVal"), minValue, digits);
        gd.addNumericField(bun.getString("MaxVal"), maxValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        minValue = gd.getNextNumber();
        maxValue = gd.getNextNumber();
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(ip, this.min, this.max);
            this.updateScrollBars(null);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)this.min, (int)this.max);
            }
        }
    }

    void setWindowLevel(ImagePlus imp, ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        double windowValue = maxValue - minValue;
        double levelValue = minValue + windowValue / 2.0;
        GenericDialog gd = new GenericDialog(bun.getString(""));
        gd.addNumericField(bun.getString("WinCenter"), levelValue, digits);
        gd.addNumericField(bun.getString("WinWidth"), windowValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        levelValue = gd.getNextNumber();
        windowValue = gd.getNextNumber();
        minValue = levelValue - windowValue / 2.0;
        maxValue = levelValue + windowValue / 2.0;
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(ip, minValue, maxValue);
            this.updateScrollBars(null);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (Recorder.record) {
                Recorder.record("setMinAndMax", (int)this.min, (int)this.max);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    /*
     * WARNING - void declaration
     */
    void doUpdate() {
        void var3_5;
        int action;
        int minvalue = this.minSliderValue;
        int maxvalue = this.maxSliderValue;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doSet) {
            action = 2;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doThreshold) {
            action = 4;
        } else if (this.doUpdate) {
            action = 9;
        } else if (this.minSliderValue >= 0) {
            action = 5;
        } else if (this.maxSliderValue >= 0) {
            action = 6;
        } else if (this.brightnessValue >= 0) {
            action = 7;
        } else if (this.contrastValue >= 0) {
            action = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doUpdate = false;
        this.doThreshold = false;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus(bun.getString("NoImg"));
            return;
        }
        ImageProcessor ip = var3_5 != 9 ? this.setup(imp) : imp.getProcessor();
        if (this.RGBImage && !imp.lock()) {
            imp = null;
            return;
        }
        switch (var3_5) {
            case 0: {
                this.reset(imp, ip);
                break;
            }
            case 1: {
                this.autoAdjust(imp, ip);
                break;
            }
            case 2: {
                if (this.windowLevel) {
                    this.setWindowLevel(imp, ip);
                    break;
                }
                this.setMinAndMax(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp, ip);
                break;
            }
            case 9: {
                this.update(imp, ip);
                break;
            }
            case 5: {
                this.adjustMin(imp, ip, minvalue);
                break;
            }
            case 6: {
                this.adjustMax(imp, ip, maxvalue);
                break;
            }
            case 7: {
                this.adjustBrightness(imp, ip, bvalue);
                break;
            }
            case 8: {
                this.adjustContrast(imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        imp.updateAndDraw();
        if (this.RGBImage) {
            imp.unlock();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        this.setup();
        WindowManager.setWindow(this);
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        this.channels = channelConstants[this.choice.getSelectedIndex()];
        this.doReset = true;
        this.notify();
    }

    static {
        channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
        bun = IJ.getPluginBundle();
        deb = 0;
    }
}

