/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.IJ;
import ij.util.FgaussTools;
import ij.util.IFunctionTools;
import java.awt.Color;

public class Tools {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static int[] mfit = new int[1];
    static double[] atry;
    static double[] beta;
    static double[] da;
    static double[][] oneda;

    public static String c2hex(Color c) {
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }

    public static String f2hex(float f) {
        int i = Float.floatToIntBits(f);
        char[] buf9 = new char[9];
        buf9[0] = 35;
        for (int pos = 8; pos >= 1; --pos) {
            buf9[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf9);
    }

    public static double[] getMinMax(double[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] getMinMax(float[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] toDouble(float[] a) {
        int len = a.length;
        double[] d = new double[len];
        for (int i = 0; i < len; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static float[] toFloat(double[] a) {
        int len = a.length;
        float[] f = new float[len];
        for (int i = 0; i < len; ++i) {
            f[i] = (float)a[i];
        }
        return f;
    }

    public static String fixNewLines(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r') continue;
            chars[i] = 10;
        }
        return new String(chars);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            Double d = new Double(s);
            defaultValue = d;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double parseDouble(String s) {
        return Tools.parseDouble(s, Double.NaN);
    }

    public static void fittingData(float[] xValues, float[] yValues, float[] vector) {
        int j;
        int i;
        int dim = vector.length;
        int n = xValues.length;
        float[] D = new float[dim];
        float[][] array = new float[dim][dim];
        float[][] arraytest = new float[dim][dim];
        float[][] result = new float[dim][dim];
        for (i = 0; i < dim; ++i) {
            D[i] = 0.0f;
            vector[i] = 0.0f;
            for (j = 0; j < dim; ++j) {
                array[i][j] = 0.0f;
                arraytest[i][j] = 0.0f;
                result[i][j] = 0.0f;
            }
        }
        for (i = 0; i < n; ++i) {
            D[0] = 1.0f;
            for (j = 1; j < dim; ++j) {
                D[j] = D[j - 1] * xValues[i];
            }
            for (j = 0; j < dim; ++j) {
                int n2 = j;
                vector[n2] = vector[n2] + yValues[i] * D[j];
                for (int l = j; l < dim; ++l) {
                    float[] fArray = array[j];
                    int n3 = l;
                    fArray[n3] = fArray[n3] + D[j] * D[l];
                    array[l][j] = array[j][l];
                }
            }
        }
        for (i = 0; i < dim; ++i) {
            for (j = 0; j < dim; ++j) {
                arraytest[i][j] = array[i][j];
            }
        }
        for (i = 0; i < dim; ++i) {
            int j2;
            int k;
            float aux = 1.0f / array[i][i];
            for (j = 0; j < dim; ++j) {
                array[i][j] = array[i][j] * aux;
            }
            array[i][i] = aux;
            for (k = 0; k < i; ++k) {
                aux = array[k][i];
                for (j2 = 0; j2 < dim; ++j2) {
                    float[] fArray = array[k];
                    int n4 = j2;
                    fArray[n4] = fArray[n4] - aux * array[i][j2];
                }
                array[k][i] = -aux * array[i][i];
            }
            for (k = i + 1; k < dim; ++k) {
                aux = array[k][i];
                for (j2 = 0; j2 < dim; ++j2) {
                    float[] fArray = array[k];
                    int n5 = j2;
                    fArray[n5] = fArray[n5] - aux * array[i][j2];
                }
                array[k][i] = -aux * array[i][i];
            }
        }
        for (i = 0; i < dim; ++i) {
            D[i] = vector[i];
            vector[i] = 0.0f;
        }
        for (i = 0; i < dim; ++i) {
            for (j = 0; j < dim; ++j) {
                int n6 = i;
                vector[n6] = vector[n6] + D[j] * array[i][j];
            }
        }
    }

    public static void covsrt(double[][] covar, int ma, int[] ia, int[] mfit) {
        int j;
        int i;
        for (i = mfit[0]; i < ma; ++i) {
            for (j = 0; j <= i; ++j) {
                covar[j][i] = 0.0;
                covar[i][j] = 0.0;
            }
        }
        int k = mfit[0] - 1;
        for (j = ma - 1; j >= 0; --j) {
            if (ia[j] == 0) continue;
            if (k != j) {
                double swap;
                for (i = 0; i < ma; ++i) {
                    swap = covar[i][k];
                    covar[i][k] = covar[i][j];
                    covar[i][j] = swap;
                }
                for (i = 0; i < ma; ++i) {
                    swap = covar[k][i];
                    covar[k][i] = covar[j][i];
                    covar[j][i] = swap;
                }
            }
            --k;
        }
    }

    public static int gaussj(double[][] a, int n, double[][] b, int m) {
        double swap;
        int l;
        int k;
        int j;
        int[] indxc = new int[n];
        int[] indxr = new int[n];
        int[] ipiv = new int[n];
        int icol = 0;
        int irow = 0;
        for (j = 0; j < n; ++j) {
            ipiv[j] = 0;
        }
        for (int i = 0; i < n; ++i) {
            double big = 0.0;
            for (j = 0; j < n; ++j) {
                if (ipiv[j] == 1) continue;
                for (k = 0; k < n; ++k) {
                    if (ipiv[k] == 0) {
                        if (!(Math.abs(a[j][k]) >= big)) continue;
                        big = Math.abs(a[j][k]);
                        irow = j;
                        icol = k;
                        continue;
                    }
                    if (ipiv[k] <= 1) continue;
                    IJ.error(IJ.getPluginBundle().getString("error2"));
                    return 0;
                }
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                for (l = 0; l < n; ++l) {
                    swap = a[irow][l];
                    a[irow][l] = a[icol][l];
                    a[icol][l] = swap;
                }
                for (l = 0; l < m; ++l) {
                    swap = b[irow][l];
                    b[irow][l] = b[icol][l];
                    b[icol][l] = swap;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                IJ.error(IJ.getPluginBundle().getString("error2"));
                return 0;
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                double[] dArray = b[icol];
                int n4 = l++;
                dArray[n4] = dArray[n4] * pivinv;
            }
            for (int ll = 0; ll < n; ++ll) {
                if (ll == icol) continue;
                double dum = a[ll][icol];
                a[ll][icol] = 0.0;
                for (l = 0; l < n; ++l) {
                    double[] dArray = a[ll];
                    int n5 = l;
                    dArray[n5] = dArray[n5] - a[icol][l] * dum;
                }
                for (l = 0; l < m; ++l) {
                    double[] dArray = b[ll];
                    int n6 = l;
                    dArray[n6] = dArray[n6] - b[icol][l] * dum;
                }
            }
        }
        for (l = n - 1; l >= 0; --l) {
            if (indxr[l] == indxc[l]) continue;
            for (k = 0; k < n; ++k) {
                swap = a[k][indxr[l]];
                a[k][indxr[l]] = a[k][indxc[l]];
                a[k][indxc[l]] = swap;
            }
        }
        return 1;
    }

    public static void mrqcof(double[] x, double[] y, double[] sig, int ndata, double[] a, int[] ia, int ma, double[][] alpha, double[] beta, IFunctionTools funcs, double[] chisq) {
        int k;
        int j;
        int mfit = 0;
        double[] dyda = new double[ma];
        for (j = 0; j < ma; ++j) {
            if (ia[j] == 0) continue;
            ++mfit;
        }
        for (j = 0; j < mfit; ++j) {
            for (k = 0; k <= j; ++k) {
                alpha[j][k] = 0.0;
            }
            beta[j] = 0.0;
        }
        chisq[0] = 0.0;
        for (int i = 0; i < ndata; ++i) {
            double ymod = funcs.run(x[i], a, dyda, ma);
            double sig2i = 1.0 / (sig[i] * sig[i]);
            double dy = y[i] - ymod;
            j = -1;
            for (int l = 0; l < ma; ++l) {
                if (ia[l] == 0) continue;
                double wt = dyda[l] * sig2i;
                ++j;
                k = 0;
                for (int m = 0; m <= l; ++m) {
                    if (ia[m] == 0) continue;
                    double[] dArray = alpha[j];
                    int n = k++;
                    dArray[n] = dArray[n] + wt * dyda[m];
                }
                int n = j;
                beta[n] = beta[n] + dy * wt;
            }
            chisq[0] = chisq[0] + dy * dy * sig2i;
        }
        for (j = 1; j < mfit; ++j) {
            for (k = 0; k < j; ++k) {
                alpha[k][j] = alpha[j][k];
            }
        }
    }

    public static int mrqmin(double[] x, double[] y, double[] sig, int ndata, double[] a, int[] ia, int ma, double[][] covar, double[][] alpha, double[] chisq, double[] ochisq, double[] alamda) {
        int l;
        int k;
        int j;
        FgaussTools funcs = new FgaussTools();
        if (alamda[0] < 0.0) {
            atry = new double[ma];
            beta = new double[ma];
            da = new double[ma];
            Tools.mfit[0] = 0;
            for (j = 0; j < ma; ++j) {
                if (ia[j] == 0) continue;
                mfit[0] = mfit[0] + 1;
            }
            oneda = new double[mfit[0]][1];
            alamda[0] = 0.001;
            Tools.mrqcof(x, y, sig, ndata, a, ia, ma, alpha, beta, funcs, chisq);
            ochisq[0] = chisq[0];
            for (j = 0; j < ma; ++j) {
                Tools.atry[j] = a[j];
            }
        }
        for (j = 0; j < mfit[0]; ++j) {
            for (k = 0; k < mfit[0]; ++k) {
                covar[j][k] = alpha[j][k];
            }
            covar[j][j] = alpha[j][j] * (1.0 + alamda[0]);
            Tools.oneda[j][0] = beta[j];
        }
        int err = Tools.gaussj(covar, mfit[0], oneda, 1);
        if (err == 0) {
            return 0;
        }
        for (j = 0; j < mfit[0]; ++j) {
            Tools.da[j] = oneda[j][0];
        }
        if (alamda[0] == 0.0) {
            Tools.covsrt(covar, ma, ia, mfit);
            return 1;
        }
        j = 0;
        for (l = 0; l < ma; ++l) {
            if (ia[l] == 0) continue;
            Tools.atry[l] = a[l] + da[j++];
        }
        Tools.mrqcof(x, y, sig, ndata, atry, ia, ma, covar, da, funcs, chisq);
        if (chisq[0] < ochisq[0]) {
            alamda[0] = alamda[0] * 0.1;
            ochisq[0] = chisq[0];
            for (j = 0; j < mfit[0]; ++j) {
                for (k = 0; k < mfit[0]; ++k) {
                    alpha[j][k] = covar[j][k];
                }
                Tools.beta[j] = da[j];
            }
            for (l = 0; l < ma; ++l) {
                a[l] = atry[l];
            }
        } else {
            alamda[0] = alamda[0] * 10.0;
            chisq[0] = ochisq[0];
        }
        return 1;
    }

    public static void Fgauss(float[] x, double[] result, int ma, float[] y) {
        FgaussTools funcs = new FgaussTools();
        double[] dy = new double[3];
        double[] a = new double[]{result[3 * ma], result[3 * ma + 1], result[3 * ma + 2]};
        for (int i = 0; i < y.length; ++i) {
            y[i] = (float)funcs.run(x[i], a, dy, 3);
        }
    }

    public static float Fgauss(double x, double[] a) {
        FgaussTools funcs = new FgaussTools();
        double[] dy = new double[3];
        return (float)funcs.run(x, a, dy, 3);
    }
}

