/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlDocletWriter {
    protected final ClassTree classtree;

    protected AbstractTreeWriter(ConfigurationImpl configurationImpl, String string, ClassTree classTree) throws IOException {
        super(configurationImpl, string);
        this.classtree = classTree;
    }

    protected AbstractTreeWriter(ConfigurationImpl configurationImpl, String string, String string2, ClassTree classTree, PackageDoc packageDoc) throws IOException {
        super(configurationImpl, string, string2, DirectoryManager.getRelativePath(packageDoc.name()));
        this.classtree = classTree;
    }

    protected void generateLevelInfo(ClassDoc classDoc, List list, boolean bl) {
        if (list.size() > 0) {
            this.ul();
            for (int i = 0; i < list.size(); ++i) {
                ClassDoc classDoc2 = (ClassDoc)list.get(i);
                this.printPartialInfo(classDoc2);
                this.printExtendsImplements(classDoc, classDoc2);
                this.generateLevelInfo(classDoc2, this.classtree.subs(classDoc2, bl), bl);
            }
            this.ulEnd();
        }
    }

    protected void generateTree(List list, String string) {
        if (list.size() > 0) {
            ClassDoc classDoc = (ClassDoc)list.get(0);
            this.printTreeHeading(string);
            this.generateLevelInfo(!classDoc.isInterface() ? classDoc : null, list, list == this.classtree.baseEnums());
        }
    }

    protected void printExtendsImplements(ClassDoc classDoc, ClassDoc classDoc2) {
        Object[] objectArray = classDoc2.interfaces();
        if (objectArray.length > (classDoc2.isInterface() ? 1 : 0)) {
            Arrays.sort(objectArray);
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (classDoc == objectArray[i] || !objectArray[i].isPublic() && !Util.isLinkable((ClassDoc)objectArray[i], this.configuration())) continue;
                if (n == 0) {
                    if (classDoc2.isInterface()) {
                        this.print(" (" + this.configuration.getText("doclet.also") + " extends ");
                    } else {
                        this.print(" (implements ");
                    }
                } else {
                    this.print(", ");
                }
                this.printPreQualifiedClassLink(12, (ClassDoc)objectArray[i]);
                ++n;
            }
            if (n > 0) {
                this.println(")");
            }
        }
    }

    protected void printPartialInfo(ClassDoc classDoc) {
        this.li("circle");
        this.printPreQualifiedBoldClassLink(12, classDoc);
    }

    protected void printTreeHeading(String string) {
        this.h2();
        this.println(this.configuration.getText(string));
        this.h2End();
    }

    protected void navLinkTree() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Tree");
        this.fontEnd();
        this.navCellEnd();
    }
}

