/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import java.util.StringTokenizer;

class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final String classId;
    String stem;

    PatternReferenceTypeSpec(String string) throws ClassNotFoundException {
        this.classId = string;
        this.stem = string;
        if (string.startsWith("*")) {
            this.stem = this.stem.substring(1);
        } else if (string.endsWith("*")) {
            this.stem = this.stem.substring(0, string.length() - 1);
        }
        this.checkClassName(this.stem);
    }

    public boolean isUnique() {
        return this.classId.equals(this.stem);
    }

    public boolean matches(ReferenceType referenceType) {
        if (this.classId.startsWith("*")) {
            return referenceType.name().endsWith(this.stem);
        }
        if (this.classId.endsWith("*")) {
            return referenceType.name().startsWith(this.stem);
        }
        return referenceType.name().equals(this.classId);
    }

    public ClassPrepareRequest createPrepareRequest() {
        ClassPrepareRequest classPrepareRequest = Env.vm().eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.classId);
        classPrepareRequest.addCountFilter(1);
        return classPrepareRequest;
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec patternReferenceTypeSpec = (PatternReferenceTypeSpec)object;
            return this.classId.equals(patternReferenceTypeSpec.classId);
        }
        return false;
    }

    private void checkClassName(String string) throws ClassNotFoundException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.isJavaIdentifier(string2)) continue;
            throw new ClassNotFoundException();
        }
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.codePointAt(0);
        if (!Character.isJavaIdentifierStart(n)) {
            return false;
        }
        for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isJavaIdentifierPart(n)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.classId;
    }
}

